/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.actions;

import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPsiFile;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HbEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/dmarcotte/handlebars/editor/actions/HbEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/dmarcotte/handlebars/editor/actions/HbEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/dmarcotte/handlebars/editor/actions/HbEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/dmarcotte/handlebars/editor/actions/HbEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/dmarcotte/handlebars/editor/actions/HbEnterHandler", "preprocessEnter"));
        }
        if (file instanceof HbPsiFile && HbEnterHandler.isBetweenHbTags(editor, file, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, dataContext);
            return EnterHandlerDelegate.Result.Default;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenHbTags(Editor editor, PsiFile file, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '}') {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement openerElement = file.findElementAt(iterator.getStart());
        HbOpenBlockMustache openTag = HbPsiUtil.findParentOpenTagElement(openerElement);
        if (openTag == null) {
            return false;
        }
        iterator.advance();
        if (iterator.atEnd()) {
            return false;
        }
        PsiElement closerElement = file.findElementAt(iterator.getStart());
        HbCloseBlockMustache closeTag = HbPsiUtil.findParentCloseTagElement(closerElement);
        return closeTag != null;
    }
}

