/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.actions;

import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbBlockWrapper;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbMustache;
import com.dmarcotte.handlebars.psi.HbMustacheName;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.dmarcotte.handlebars.psi.HbSimpleInverse;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class HbTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.dmarcotte.handlebars.editor.actions.HbTypedHandler");
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACES = "}}";

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0 || offset > editor.getDocument().getTextLength()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String previousChar = editor.getDocument().getText(new TextRange(offset - 1, offset));
        if (file.getLanguage() instanceof HbLanguage) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (c == '{' && previousChar.equals(OPEN_BRACE)) {
                editor.getDocument().insertString(offset, (CharSequence)Character.toString(c));
                editor.getCaretModel().moveToOffset(offset + 1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/dmarcotte/handlebars/editor/actions/HbTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/dmarcotte/handlebars/editor/actions/HbTypedHandler", "charTyped"));
        }
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider provider = file.getViewProvider();
        if (!provider.getBaseLanguage().isKindOf((Language)HbLanguage.INSTANCE)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (offset < 2 || offset > editor.getDocument().getTextLength()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String previousChar = editor.getDocument().getText(new TextRange(offset - 2, offset - 1));
        boolean closeBraceCompleted = false;
        if (file.getLanguage() instanceof HbLanguage && HbConfig.isAutocompleteMustachesEnabled() && c == '}' && !previousChar.equals("}")) {
            PsiElement mustache;
            ASTNode node;
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement elementAt = provider.findElementAt(offset - 1, provider.getBaseLanguage());
            ASTNode aSTNode = node = elementAt != null ? elementAt.getNode() : null;
            if (node != null && node.getElementType() == HbTokenTypes.INVALID && (mustache = PsiTreeUtil.findFirstParent((PsiElement)elementAt, psiElement -> psiElement instanceof HbMustache)) != null) {
                String braceCompleter = mustache.getFirstChild().getNode().getElementType() == HbTokenTypes.OPEN_UNESCAPED ? CLOSE_BRACES : "}";
                editor.getDocument().insertString(offset, (CharSequence)braceCompleter);
                editor.getCaretModel().moveToOffset(offset += braceCompleter.length());
                closeBraceCompleted = true;
            }
        }
        if (closeBraceCompleted || c == '}' && previousChar.equals("}")) {
            HbTypedHandler.autoInsertCloseTag(project, offset, editor, provider);
            HbTypedHandler.adjustMustacheFormatting(project, offset, editor, file, provider);
        } else if (c == '/' && previousChar.equals(OPEN_BRACE)) {
            HbTypedHandler.finishClosingTag(offset, editor, provider);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void finishClosingTag(int offset, Editor editor, FileViewProvider provider) {
        HbBlockWrapper block;
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        if (elementAtCaret != null && (block = (HbBlockWrapper)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, HbBlockWrapper.class)) != null) {
            HbMustacheName mustacheName;
            HbOpenBlockMustache open = (HbOpenBlockMustache)PsiTreeUtil.findChildOfType((PsiElement)block, HbOpenBlockMustache.class);
            HbCloseBlockMustache close = (HbCloseBlockMustache)PsiTreeUtil.findChildOfType((PsiElement)block, HbCloseBlockMustache.class);
            if (open != null && close == null && (mustacheName = (HbMustacheName)PsiTreeUtil.findChildOfType((PsiElement)open, HbMustacheName.class)) != null) {
                if (offset > 3) {
                    String prePreviousChar = editor.getDocument().getText(new TextRange(offset - 3, offset - 2));
                    if (prePreviousChar.equals(OPEN_BRACE)) {
                        editor.getDocument().insertString(offset, (CharSequence)(mustacheName.getText() + CLOSE_BRACES));
                        editor.getCaretModel().moveToOffset(offset + mustacheName.getText().length() + CLOSE_BRACES.length());
                    } else {
                        editor.getDocument().replaceString(offset - 1, offset, (CharSequence)("{/" + mustacheName.getText() + CLOSE_BRACES));
                        editor.getCaretModel().moveToOffset(offset + mustacheName.getText().length() + CLOSE_BRACES.length() + 1);
                    }
                } else {
                    LOG.warn("Unexpected offset inside HbBlockWrapper element");
                }
            }
        }
    }

    private static void autoInsertCloseTag(Project project, int offset, Editor editor, FileViewProvider provider) {
        HbMustacheName mustacheName;
        if (!HbConfig.isAutoGenerateCloseTagEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        if (elementAtCaret == null || elementAtCaret.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return;
        }
        HbOpenBlockMustache openTag = HbPsiUtil.findParentOpenTagElement(elementAtCaret);
        if (openTag != null && openTag.getChildren().length > 1 && (mustacheName = (HbMustacheName)PsiTreeUtil.findChildOfType((PsiElement)openTag, HbMustacheName.class)) != null) {
            editor.getDocument().insertString(offset, (CharSequence)("{{/" + mustacheName.getText() + CLOSE_BRACES));
        }
    }

    private static void adjustMustacheFormatting(Project project, int offset, Editor editor, PsiFile file, FileViewProvider provider) {
        if (!HbConfig.isFormattingEnabled()) {
            return;
        }
        PsiElement elementAtCaret = provider.findElementAt(offset - 1, HbLanguage.class);
        PsiElement closeOrSimpleInverseParent = PsiTreeUtil.findFirstParent((PsiElement)elementAtCaret, (boolean)true, element -> element != null && (element instanceof HbSimpleInverse || element instanceof HbCloseBlockMustache));
        if (closeOrSimpleInverseParent != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            CaretModel caretModel = editor.getCaretModel();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.adjustLineIndent(file, editor.getDocument().getLineStartOffset(caretModel.getLogicalPosition().line));
        }
    }
}

