/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.folding;

import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbBlockWrapper;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        this.appendDescriptors(node.getPsi(), descriptors, document);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private void appendDescriptors(PsiElement psi, List<FoldingDescriptor> descriptors, Document document) {
        ASTNode commentNode;
        String commentText;
        if (HbFoldingBuilder.isSingleLine(psi, document)) {
            return;
        }
        if (HbTokenTypes.COMMENT == psi.getNode().getElementType() && (commentText = (commentNode = psi.getNode()).getText()).length() > 6 && commentText.substring(0, 3).equals("{{!") && commentText.substring(commentText.length() - 2, commentText.length()).equals("}}")) {
            TextRange range = new TextRange(commentNode.getTextRange().getStartOffset() + 3, commentNode.getTextRange().getEndOffset() - 2);
            descriptors.add(new FoldingDescriptor(commentNode, range));
        }
        if (psi instanceof HbBlockWrapper) {
            PsiElement endOpenBlockStache = this.getOpenBlockCloseStacheElement(psi.getFirstChild());
            PsiElement endCloseBlockStache = this.getCloseBlockCloseStacheElement(psi.getLastChild());
            if (endOpenBlockStache != null && endCloseBlockStache != null) {
                int endOfFirstOpenStacheLine = document.getLineEndOffset(document.getLineNumber(psi.getTextRange().getStartOffset()));
                int foldingRangeStartOffset = Math.min(endOpenBlockStache.getTextRange().getStartOffset(), endOfFirstOpenStacheLine);
                int foldingRangeEndOffset = endCloseBlockStache.getTextRange().getStartOffset();
                TextRange range = new TextRange(foldingRangeStartOffset, foldingRangeEndOffset);
                descriptors.add(new FoldingDescriptor(psi, range));
            }
        }
        for (PsiElement child = psi.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.appendDescriptors(child, descriptors, document);
        }
    }

    private PsiElement getOpenBlockCloseStacheElement(PsiElement psiElement) {
        if (psiElement == null || !(psiElement instanceof HbOpenBlockMustache)) {
            return null;
        }
        PsiElement endOpenStache = psiElement.getLastChild();
        if (endOpenStache == null || endOpenStache.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return null;
        }
        return endOpenStache;
    }

    private PsiElement getCloseBlockCloseStacheElement(PsiElement psiElement) {
        if (psiElement == null || !(psiElement instanceof HbCloseBlockMustache)) {
            return null;
        }
        PsiElement endCloseStache = psiElement.getLastChild();
        if (endCloseStache == null || endCloseStache.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return null;
        }
        return endCloseStache;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder", "isCollapsedByDefault"));
        }
        return HbConfig.isAutoCollapseBlocksEnabled();
    }

    private static boolean isSingleLine(PsiElement element, Document document) {
        TextRange range = element.getTextRange();
        return document.getLineNumber(range.getStartOffset()) == document.getLineNumber(range.getEndOffset());
    }
}

