/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.file;

import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class HbFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myBaseLanguage;
    private final Language myTemplateLanguage;
    private static final ConcurrentMap<String, TemplateDataElementType> TEMPLATE_DATA_TO_LANG = ContainerUtil.newConcurrentMap();

    private static TemplateDataElementType getTemplateDataElementType(Language lang) {
        TemplateDataElementType result = (TemplateDataElementType)TEMPLATE_DATA_TO_LANG.get(lang.getID());
        if (result != null) {
            return result;
        }
        TemplateDataElementType created = new TemplateDataElementType("HB_TEMPLATE_DATA", lang, HbTokenTypes.CONTENT, HbTokenTypes.OUTER_ELEMENT_TYPE);
        TemplateDataElementType prevValue = TEMPLATE_DATA_TO_LANG.putIfAbsent(lang.getID(), created);
        return prevValue == null ? created : prevValue;
    }

    public HbFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language baseLanguage) {
        this(manager, file, physical, baseLanguage, HbFileViewProvider.getTemplateDataLanguage(manager, file));
    }

    public HbFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language baseLanguage, Language templateLanguage) {
        super(manager, file, physical);
        this.myBaseLanguage = baseLanguage;
        this.myTemplateLanguage = templateLanguage;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/dmarcotte/handlebars/file/HbFileViewProvider", "supportsIncrementalReparse"));
        }
        return false;
    }

    @NotNull
    private static Language getTemplateDataLanguage(PsiManager manager, VirtualFile file) {
        Language dataLang = TemplateDataLanguageMappings.getInstance((Project)manager.getProject()).getMapping(file);
        if (dataLang == null) {
            dataLang = HbLanguage.getDefaultTemplateLang().getLanguage();
        }
        Language substituteLang = LanguageSubstitutors.INSTANCE.substituteLanguage(dataLang, file, manager.getProject());
        if (TemplateDataLanguageMappings.getTemplateableLanguages().contains(substituteLang)) {
            dataLang = substituteLang;
        }
        Language language = dataLang;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/file/HbFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/file/HbFileViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/file/HbFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet tHashSet = new THashSet(Arrays.asList(this.myBaseLanguage, this.getTemplateDataLanguage()));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/file/HbFileViewProvider", "getLanguages"));
        }
        return tHashSet;
    }

    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile virtualFile) {
        return new HbFileViewProvider(this.getManager(), virtualFile, false, this.myBaseLanguage, this.myTemplateLanguage);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/dmarcotte/handlebars/file/HbFileViewProvider", "createFile"));
        }
        ParserDefinition parserDefinition = this.getDefinition(lang);
        if (parserDefinition == null) {
            return null;
        }
        if (lang.is(this.getTemplateDataLanguage())) {
            PsiFileImpl file = (PsiFileImpl)parserDefinition.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)HbFileViewProvider.getTemplateDataElementType(this.getBaseLanguage()));
            return file;
        }
        if (lang.isKindOf(this.getBaseLanguage())) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    private ParserDefinition getDefinition(Language lang) {
        ParserDefinition parserDefinition = lang.isKindOf(this.getBaseLanguage()) ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang.is(this.getBaseLanguage()) ? lang : this.getBaseLanguage()) : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        return parserDefinition;
    }
}

