/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.format;

import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.formatting.templateLanguages.TemplateLanguageFormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbFormattingModelBuilder
extends TemplateLanguageFormattingModelBuilder {
    public TemplateLanguageBlock createTemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull CodeStyleSettings codeStyleSettings) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder", "createTemplateLanguageBlock"));
        }
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder", "createTemplateLanguageBlock"));
        }
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)node.getPsi().getContainingFile());
        HtmlPolicy policy = new HtmlPolicy(codeStyleSettings, (FormattingDocumentModel)documentModel);
        return HbTokenTypes.TAGS.contains(node.getElementType()) ? new HandlebarsTagBlock(node, wrap, alignment, (TemplateLanguageBlockFactory)this, codeStyleSettings, foreignChildren, policy) : new HandlebarsBlock(node, wrap, alignment, (TemplateLanguageBlockFactory)this, codeStyleSettings, foreignChildren, policy);
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        if (!HbConfig.isFormattingEnabled()) {
            FormattingModel formattingModel = new SimpleTemplateLanguageFormattingModelBuilder().createModel(element, settings);
            if (formattingModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder", "createModel"));
            }
            return formattingModel;
        }
        PsiFile file = element.getContainingFile();
        ASTNode node = element.getNode();
        if (node.getElementType() == HbTokenTypes.OUTER_ELEMENT_TYPE) {
            FormattingModel formattingModel = new SimpleTemplateLanguageFormattingModelBuilder().createModel(element, settings);
            if (formattingModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder", "createModel"));
            }
            return formattingModel;
        }
        Block rootBlock = this.getRootBlock((PsiElement)file, file.getViewProvider(), settings);
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel(rootBlock, element.getProject(), settings, file.getFileType(), file);
        if (documentBasedFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder", "createModel"));
        }
        return documentBasedFormattingModel;
    }

    public boolean dontFormatMyModel() {
        return false;
    }

    private static boolean isAttribute(ASTNode child) {
        IElementType type = child.getElementType();
        return type == HbTokenTypes.PARAM || type == HbTokenTypes.HASH;
    }

    private static class HandlebarsBlock
    extends TemplateLanguageBlock {
        @NotNull
        protected final HtmlPolicy myHtmlPolicy;

        HandlebarsBlock(@NotNull ASTNode node, Wrap wrap, Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull HtmlPolicy htmlPolicy) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "<init>"));
            }
            if (blockFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "<init>"));
            }
            if (htmlPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlPolicy", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "<init>"));
            }
            super(node, wrap, alignment, blockFactory, settings, foreignChildren);
            this.myHtmlPolicy = htmlPolicy;
        }

        public Indent getIndent() {
            if (this.myNode.getText().trim().length() == 0) {
                return Indent.getNoneIndent();
            }
            if (HbFormattingModelBuilder.isAttribute(this.myNode)) {
                return null;
            }
            if (HbPsiUtil.isNonRootStatementsElement(this.myNode.getPsi())) {
                XmlTag xmlTag;
                DataLanguageBlockWrapper foreignBlockParent = this.getForeignBlockParent(false);
                if (foreignBlockParent == null) {
                    return Indent.getNormalIndent();
                }
                if (foreignBlockParent.getNode() instanceof XmlTag && !this.myHtmlPolicy.indentChildrenOf(xmlTag = (XmlTag)foreignBlockParent.getNode())) {
                    return Indent.getNormalIndent();
                }
                return Indent.getNoneIndent();
            }
            if (this.myNode.getTreeParent() != null && HbPsiUtil.isNonRootStatementsElement(this.myNode.getTreeParent().getPsi()) && this.getParent() instanceof HandlebarsBlock && ((HandlebarsBlock)this.getParent()).getIndent() == Indent.getNoneIndent()) {
                return Indent.getNormalIndent();
            }
            DataLanguageBlockWrapper foreignParent = this.getForeignBlockParent(true);
            if (foreignParent != null) {
                if (foreignParent.getNode() instanceof XmlTag && !this.myHtmlPolicy.indentChildrenOf((XmlTag)foreignParent.getNode())) {
                    return Indent.getNoneIndent();
                }
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }

        protected IElementType getTemplateTextElementType() {
            return HbTokenTypes.CONTENT;
        }

        public boolean isRequiredRange(TextRange range) {
            return false;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            if (this.myNode.getElementType() == HbTokenTypes.BLOCK_WRAPPER || this.getParent() instanceof DataLanguageBlockWrapper && (this.myNode.getElementType() != HbTokenTypes.STATEMENTS || this.myNode.getTreeNext() instanceof PsiErrorElement)) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        private DataLanguageBlockWrapper getForeignBlockParent(boolean immediate) {
            DataLanguageBlockWrapper foreignBlockParent = null;
            for (BlockWithParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof DataLanguageBlockWrapper && !(((DataLanguageBlockWrapper)parent).getOriginal() instanceof SyntheticBlock)) {
                    foreignBlockParent = (DataLanguageBlockWrapper)parent;
                    break;
                }
                if (immediate && parent instanceof HandlebarsBlock) break;
            }
            return foreignBlockParent;
        }
    }

    private static class HandlebarsTagBlock
    extends HandlebarsBlock {
        @NotNull
        private final Alignment myChildAttributeAlignment;

        HandlebarsTagBlock(@NotNull ASTNode node, Wrap wrap, Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren, HtmlPolicy htmlPolicy) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock", "<init>"));
            }
            if (blockFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock", "<init>"));
            }
            super(node, wrap, alignment, blockFactory, settings, foreignChildren, htmlPolicy);
            this.myChildAttributeAlignment = Alignment.createAlignment();
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ASTNode node;
            Block prevBlock;
            List blocks;
            if (newChildIndex > 0 && (blocks = this.getSubBlocks()).size() > newChildIndex - 1 && (prevBlock = (Block)blocks.get(newChildIndex - 1)) instanceof AbstractBlock && (HbFormattingModelBuilder.isAttribute(node = ((AbstractBlock)prevBlock).getNode()) || node.getElementType() == HbTokenTypes.MUSTACHE_NAME)) {
                ChildAttributes childAttributes = new ChildAttributes(null, prevBlock.getAlignment());
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        protected Alignment createChildAlignment(ASTNode child) {
            if (HbFormattingModelBuilder.isAttribute(child)) {
                return this.myChildAttributeAlignment;
            }
            return super.createChildAlignment(child);
        }

        protected Wrap createChildWrap(ASTNode child) {
            if (HbFormattingModelBuilder.isAttribute(child)) {
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.myHtmlPolicy.getAttributesWrap()), (boolean)false);
            }
            return null;
        }
    }
}

