/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.psi.HbBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPath;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class HbBlockMismatchFix
implements IntentionAction {
    private final boolean myUpdateOpenMustache;
    private final String myCorrectedName;
    private final String myOriginalName;

    public HbBlockMismatchFix(String correctedName, String originalName, boolean updateOpenMustache) {
        this.myUpdateOpenMustache = updateOpenMustache;
        this.myCorrectedName = correctedName;
        this.myOriginalName = originalName;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        HbBlockMustache blockMustache;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        if ((blockMustache = (HbBlockMustache)PsiTreeUtil.findFirstParent((PsiElement)psiElement, (boolean)true, psiElement1 -> psiElement1 instanceof HbBlockMustache)) == null) {
            return;
        }
        HbBlockMustache targetBlockMustache = blockMustache;
        if (this.myUpdateOpenMustache != targetBlockMustache instanceof HbOpenBlockMustache) {
            targetBlockMustache = blockMustache.getPairedElement();
        }
        HbPath path = (HbPath)PsiTreeUtil.findChildOfType((PsiElement)targetBlockMustache, HbPath.class);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (path != null && document != null) {
            TextRange textRange = path.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)this.myCorrectedName);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private String getName() {
        return this.myUpdateOpenMustache ? HbBundle.message("hb.block.mismatch.intention.rename.open", this.myOriginalName, this.myCorrectedName) : HbBundle.message("hb.block.mismatch.intention.rename.close", this.myOriginalName, this.myCorrectedName);
    }
}

