/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbParam;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HbEmptyBlockInspection
extends LocalInspectionTool {
    private static final Set<String> HELPERS_WITH_ARGUMENTS = ContainerUtil.immutableSet((Object[])new String[]{"if", "each", "with"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/dmarcotte/handlebars/inspections/HbEmptyBlockInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof HbOpenBlockMustache)) {
                    return;
                }
                String name = ((HbOpenBlockMustache)element).getName();
                if (HELPERS_WITH_ARGUMENTS.contains(name) && null == PsiTreeUtil.getChildrenOfType((PsiElement)element, HbParam.class)) {
                    holder.registerProblem(element, HbBundle.message("hb.block.mismatch.inspection.empty.block", name), new LocalQuickFix[0]);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/inspections/HbEmptyBlockInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

