/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.file.HbFileViewProvider;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.codeInsight.highlighting.TemplateLanguageErrorFilter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class HbErrorFilter
extends TemplateLanguageErrorFilter {
    private static final TokenSet START_TEMPLATE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{HbTokenTypes.OPEN, HbTokenTypes.OPEN_PARTIAL, HbTokenTypes.OPEN_BLOCK, HbTokenTypes.OPEN_INVERSE});

    protected HbErrorFilter() {
        super(START_TEMPLATE_TOKENS, HbFileViewProvider.class, new String[]{"HTML"});
    }

    protected boolean shouldIgnoreErrorAt(@NotNull FileViewProvider viewProvider, int offset) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/dmarcotte/handlebars/inspections/HbErrorFilter", "shouldIgnoreErrorAt"));
        }
        if (super.shouldIgnoreErrorAt(viewProvider, offset)) {
            return true;
        }
        return HbErrorFilter.hasWhitespacesInHtmlBetweenErrorAndOpenTokens(offset, (TemplateLanguageFileViewProvider)viewProvider);
    }

    private static boolean hasWhitespacesInHtmlBetweenErrorAndOpenTokens(int offset, TemplateLanguageFileViewProvider viewProvider) {
        PsiElement at = viewProvider.findElementAt(offset, viewProvider.getTemplateDataLanguage());
        if (!(at instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement elementAt = viewProvider.findElementAt(at.getTextRange().getEndOffset() + 1, viewProvider.getBaseLanguage());
        return elementAt != null && START_TEMPLATE_TOKENS.contains(elementAt.getNode().getElementType());
    }
}

