/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.structure;

import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.file.HbFileType;
import com.dmarcotte.handlebars.psi.HbPsiFile;
import com.dmarcotte.handlebars.structure.HbStructureViewModel;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.impl.TemplateLanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final PsiFile psiFile) {
        return new TemplateLanguageStructureViewBuilder((PsiElement)psiFile){

            protected StructureViewComposite.StructureViewDescriptor createMainView(FileEditor fileEditor, PsiFile mainFile) {
                if (!psiFile.isValid()) {
                    return null;
                }
                TreeBasedStructureViewBuilder builder = new TreeBasedStructureViewBuilder(){

                    @NotNull
                    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                        HbStructureViewModel hbStructureViewModel = new HbStructureViewModel((HbPsiFile)psiFile, editor);
                        if (hbStructureViewModel == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/structure/HbStructureViewFactory$1$1", "createStructureViewModel"));
                        }
                        return hbStructureViewModel;
                    }
                };
                StructureView structureView = builder.createStructureView(fileEditor, psiFile.getProject());
                return new StructureViewComposite.StructureViewDescriptor(HbLanguage.INSTANCE.getDisplayName(), structureView, HbFileType.INSTANCE.getIcon());
            }
        };
    }
}

