/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.structure;

import com.dmarcotte.handlebars.psi.HbBlockWrapper;
import com.dmarcotte.handlebars.psi.HbPlainMustache;
import com.dmarcotte.handlebars.psi.HbPsiFile;
import com.dmarcotte.handlebars.structure.HbTreeElementFile;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HbStructureViewModel
extends TextEditorBasedStructureViewModel {
    private final HbPsiFile myFile;
    static final Class[] ourSuitableClasses = new Class[]{HbBlockWrapper.class, HbPlainMustache.class};

    public HbStructureViewModel(@NotNull HbPsiFile psiFile, @Nullable Editor editor) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/dmarcotte/handlebars/structure/HbStructureViewModel", "<init>"));
        }
        super(editor, (PsiFile)psiFile);
        this.myFile = psiFile;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (ourSuitableClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/structure/HbStructureViewModel", "getSuitableClasses"));
        }
        return ourSuitableClasses;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        HbTreeElementFile hbTreeElementFile = new HbTreeElementFile(this.myFile);
        if (hbTreeElementFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/structure/HbStructureViewModel", "getRoot"));
        }
        return hbTreeElementFile;
    }
}

