/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Optional;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorDialog;
import org.jetbrains.annotations.NotNull;

public class YeomanRunGeneratorByNameAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        VirtualFile toProcess = YeomanRunGeneratorByNameAction.getDirectoryForProcessing(e);
        if (toProcess == null || toProcess.getCanonicalPath() == null) {
            return;
        }
        YeomanRunGeneratorDialog dialog = new YeomanRunGeneratorDialog(project, toProcess, null);
        dialog.showAndGet();
        Disposer.dispose((Disposable)dialog.getForm());
    }

    private static VirtualFile getDirectoryForProcessing(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "jetbrains/plugins/yeoman/actions/YeomanRunGeneratorByNameAction", "getDirectoryForProcessing"));
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files == null) {
            return null;
        }
        Optional<VirtualFile> result = Arrays.stream(files).filter(el -> el.isDirectory()).findAny();
        return result.isPresent() ? result.get() : null;
    }
}

