/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.generators;

import com.intellij.openapi.util.text.StringUtil;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorFullInfo
implements YeomanGeneratorInfo {
    @Nullable
    private String name;
    @Nullable
    private String description;
    @Nullable
    private Object owner;
    @Nullable
    private String ownerWebsite;
    @Nullable
    private String website;
    @Nullable
    private String site;
    @Nullable
    private Object forks;
    @Nullable
    private Object created;
    @Nullable
    private Object updated;
    private int stars;

    public static YeomanGeneratorFullInfo getFullInfo(YeomanGeneratorInfo info) {
        if (info instanceof YeomanGeneratorFullInfo) {
            return (YeomanGeneratorFullInfo)info;
        }
        return info instanceof YeomanInstalledGeneratorInfo ? ((YeomanInstalledGeneratorInfo)info).getFullInfo() : null;
    }

    public int getStars() {
        return this.stars;
    }

    private YeomanGeneratorFullInfo() {
    }

    @Nullable
    public String getWebsite() {
        return this.website == null ? this.site : this.website;
    }

    @NotNull
    public String getDescription() {
        String string = StringUtil.notNullize((String)this.description);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorFullInfo", "getDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getName() {
        return YeomanGeneratorInfo.Util.getName(this.name);
    }

    @Override
    @Nullable
    public String getYoName() {
        return YeomanGeneratorInfo.Util.getYoName(this.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof YeomanGeneratorFullInfo && StringUtil.equals((CharSequence)this.name, (CharSequence)((YeomanGeneratorFullInfo)obj).name);
    }

    public YeomanGeneratorFullInfo clone() {
        YeomanGeneratorFullInfo info = new YeomanGeneratorFullInfo();
        info.name = this.name;
        info.description = this.description;
        info.owner = this.owner;
        info.ownerWebsite = this.ownerWebsite;
        info.forks = this.forks;
        info.created = this.created;
        info.updated = this.updated;
        info.stars = this.stars;
        info.website = this.website;
        info.site = this.site;
        return info;
    }

    @Override
    public int compareTo(YeomanGeneratorInfo o) {
        if (o instanceof YeomanGeneratorFullInfo) {
            YeomanGeneratorFullInfo fullInfo = (YeomanGeneratorFullInfo)o;
            return this.stars < fullInfo.stars ? -1 : (this.stars == fullInfo.stars ? StringUtil.compare((String)this.getName(), (String)o.getName(), (boolean)false) : 1);
        }
        return StringUtil.compare((String)this.getName(), (String)o.getName(), (boolean)false);
    }
}

