/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.generators;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorListParser;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;

public class YeomanGeneratorListProvider {
    public static final Logger LOGGER = Logger.getInstance(YeomanRunGeneratorForm.class);
    private static final String[] BLACKLIST = new String[]{"ft-wp", "generator-angular-phonegap", "generator-react-coffee-webpack", "generator-angular-sparkstack", "generator-ayrofast", "generator-charcoal", "generator-express-angular", "generator-fv1", "generator-gulp-webapp", "generator-ionicjs", "generator-meteor-abtx", "generator-mtb-app", "generator-onereq", "generator-react-coffee-webpack", "generator-wordpress-bob", "generator-polymer-plus", "generator-vmweb", "generator-gulp-angular-pregiotek", "generator-auto", "generator-aspnetdnx", "generator-aspnetdnx2"};
    public static final String GENERATOR_INFO_RELATIVE_PATH = "extLibs" + File.separator + "yeoman" + File.separator + "generators_info";
    public static final String INFO_FILE_NAME = "yeoman-generators-info_2.json";
    private final YeomanGlobalSettings mySettings;
    private final Lock myLock = new ReentrantLock();
    private volatile List<YeomanGeneratorFullInfo> myLoadedList = null;

    public YeomanGeneratorListProvider() {
        this.mySettings = YeomanGlobalSettings.getInstance();
    }

    private String read(boolean force) {
        try {
            return new String(FileUtil.loadFileText((File)this.getGeneratorsFile(force), (String)this.mySettings.getGeneratorsFileDefaultEncoding()));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<YeomanGeneratorFullInfo> getAvailableGenerators(boolean forceDownload) {
        List<YeomanGeneratorFullInfo> list;
        if (!forceDownload && (list = this.myLoadedList) != null) {
            return list;
        }
        String read = this.read(forceDownload);
        try {
            List result;
            Object[] parse = new YeomanGeneratorListParser().parse(read);
            this.myLoadedList = result = ContainerUtil.reverse((List)ContainerUtil.filter((Object[])parse, info -> !ArrayUtil.contains((String)info.getName(), (String[])BLACKLIST)));
            return result;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            this.cleanAvailableGenerators();
            return this.myLoadedList == null ? ContainerUtil.emptyList() : this.myLoadedList;
        }
    }

    private File getGeneratorsFile(boolean force) throws IOException {
        File file = YeomanGeneratorListProvider.getStoreFile();
        if (force && file.exists()) {
            try {
                return this.downloadJsonWithDataImpl();
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (file.exists()) {
            return file;
        }
        return this.downloadJsonWithDataImpl();
    }

    public File downloadJsonWithData() throws IOException {
        return this.downloadJsonWithDataImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File downloadJsonWithDataImpl() throws IOException {
        block10: {
            if (this.myLock.tryLock()) {
                File yoGeneratorsFile = YeomanGeneratorListProvider.getStoreFile();
                FileUtil.createParentDirs((File)yoGeneratorsFile);
                DownloadUtil.downloadAtomically(null, (String)this.mySettings.getGeneratorsFileUrl(), (File)yoGeneratorsFile);
                File file = yoGeneratorsFile;
                File file2 = file;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorListProvider", "downloadJsonWithDataImpl"));
                }
                return file2;
                finally {
                    this.myLock.unlock();
                }
            }
            this.myLock.lock();
            File yoGeneratorsFile = YeomanGeneratorListProvider.getStoreFile();
            if (!yoGeneratorsFile.exists()) break block10;
            File file = yoGeneratorsFile;
            File file3 = file;
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorListProvider", "downloadJsonWithDataImpl"));
            }
            return file3;
            finally {
                this.myLock.unlock();
            }
        }
        File file = this.downloadJsonWithDataImpl();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorListProvider", "downloadJsonWithDataImpl"));
        }
        return file;
    }

    public void cleanAvailableGenerators() {
        this.myLock.lock();
        try {
            File file = YeomanGeneratorListProvider.getStoreFile();
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public boolean isAvailableGeneratorListExists() {
        return YeomanGeneratorListProvider.getStoreFile().exists();
    }

    @NotNull
    private static File getStoreFile() {
        File file = new File(PathManager.getSystemPath(), GENERATOR_INFO_RELATIVE_PATH + File.separator + INFO_FILE_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanGeneratorListProvider", "getStoreFile"));
        }
        return file;
    }
}

