/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.generators;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanInstalledGeneratorInfo
implements YeomanGeneratorInfo {
    @NotNull
    private final String myName;
    @NotNull
    private String myFilePath;
    private boolean myIsGlobal;
    @Nullable
    private YeomanGeneratorFullInfo myFullInfo;

    @Nullable
    public YeomanGeneratorFullInfo getFullInfo() {
        return this.myFullInfo;
    }

    public YeomanInstalledGeneratorInfo(VirtualFile file) {
        this.myName = file.getNameWithoutExtension();
        this.myFilePath = file.getCanonicalPath();
        this.myIsGlobal = true;
    }

    public YeomanInstalledGeneratorInfo(File file) {
        this.myName = FileUtil.getNameWithoutExtension((File)file);
        this.myFilePath = file.getAbsolutePath();
        this.myIsGlobal = false;
    }

    @Override
    @NotNull
    public String getYoName() {
        String string = YeomanGeneratorInfo.Util.getYoName(this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanInstalledGeneratorInfo", "getYoName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanInstalledGeneratorInfo", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/generators/YeomanInstalledGeneratorInfo", "getFilePath"));
        }
        return string;
    }

    @Override
    public int compareTo(YeomanGeneratorInfo o) {
        return StringUtil.compare((String)this.getName(), (String)o.getName(), (boolean)false);
    }

    public boolean isGlobal() {
        return this.myIsGlobal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof YeomanGeneratorInfo)) {
            return false;
        }
        return this.getName().equals(((YeomanGeneratorInfo)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

