/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.template;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.platform.CustomStepProjectGenerator;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.util.NullableConsumer;
import icons.YeomanIcons;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.step.YeomanProjectSettingsStep;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorPanel;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.projectGenerator.util.YeomanCommandLineUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanProjectGenerator
implements CustomStepProjectGenerator,
DirectoryProjectGenerator<Settings> {
    public static final Logger LOGGER = Logger.getInstance(YeomanRunGeneratorForm.class);
    public static final String BOWER_JSON = "bower.json";

    @Nls
    @NotNull
    public String getName() {
        String string = YeomanBundle.message("settings.yeoman.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "getName"));
        }
        return string;
    }

    @Nullable
    public Icon getLogo() {
        return YeomanIcons.Yeoman;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable Settings settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "generateProject"));
        }
        YeomanProjectGenerator.generateProject(project, baseDir, settings);
    }

    public static void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable Settings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "generateProject"));
        }
        assert (settings != null);
        File baseDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(YeomanBundle.message("yeoman.generator.running.process", new Object[0]));
                YeomanProjectGenerator.moveFiles(new File(settings.appPath), baseDirFile);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }, YeomanBundle.message("yeoman.welcome.dialog.after.initialize", new Object[0]), false, project) && settings.runNpmAndBowerInstall && new File(baseDirFile, "package.json").exists()) {
            YeomanProjectGenerator.installAllDepends(project, baseDirFile);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("tools.yeoman.generate.project");
        baseDir.refresh(true, true);
    }

    private static void moveFiles(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromDir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "moveFiles"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "moveFiles"));
        }
        try {
            File toFile;
            File fromFile;
            File[] files = fromDir.listFiles();
            if (files == null) {
                return;
            }
            boolean success = true;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (success = (fromFile = fileArray[i]).renameTo(toFile = new File(toDir, fromFile.getName()))); ++i) {
            }
            if (success) {
                return;
            }
            FileUtil.copyDir((File)fromDir, (File)toDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            fromDir.delete();
        }
    }

    private static void installAllDepends(@NotNull Project project, @NotNull File dir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "installAllDepends"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "installAllDepends"));
        }
        GeneralCommandLine npmInstallCommandLine = YeomanCommandLineUtil.createNpmInstallCommandLine(dir);
        YeomanProjectGenerator.installDepends(project, npmInstallCommandLine, YeomanBundle.message("yeoman.generator.running.npm", new Object[0]), () -> {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "lambda$installAllDepends$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "lambda$installAllDepends$1"));
            }
            if (new File(dir, BOWER_JSON).exists()) {
                GeneralCommandLine line = YeomanCommandLineUtil.createBowerInstallCommandLine(project, dir);
                YeomanProjectGenerator.installDepends(project, line, YeomanBundle.message("yeoman.generator.running.bower", new Object[0]), null);
            }
        });
    }

    private static void installDepends(final @NotNull Project project, final @Nullable GeneralCommandLine line, String title, final Runnable success) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "installDepends"));
        }
        if (line == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "lambda$installDepends$2"));
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator$1", "run"));
                    }
                    YeomanCommandLineUtil.createExecuteCommandLineAction(project, line, (Ref<RuntimeException>)new Ref(null), indicator).run();
                }

                public boolean shouldStartInBackground() {
                    return false;
                }

                public void onSuccess() {
                    if (success != null) {
                        success.run();
                    }
                }
            });
        });
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirPath", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "validate"));
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGenerator", "validate"));
        }
        return validationResult;
    }

    public YeomanProjectGeneratorPanel createPanel() {
        Settings settings = new Settings();
        settings.tempPath = YeomanProjectGenerator.createTemp().getAbsolutePath();
        return new YeomanProjectGeneratorPanel(settings);
    }

    public static File createTemp() {
        try {
            return FileUtil.createTempDirectory((String)"yeoman-project-generator", null, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public AbstractActionWithPanel createStep(DirectoryProjectGenerator projectGenerator, NullableConsumer<? extends AbstractActionWithPanel> callback) {
        return new YeomanProjectSettingsStep(projectGenerator, callback);
    }

    public static class Settings {
        public String tempPath;
        public String appPath;
        public boolean runNpmAndBowerInstall = true;
        public String options;
        public YeomanInstalledGeneratorInfo info;
    }
}

