/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.template;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGenerator;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorOwnerPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorSubPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorWelcomePanel;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanProjectGeneratorPanel
implements Disposable,
YeomanProjectGeneratorOwnerPanel {
    private final YeomanProjectGenerator.Settings mySettings;
    JLabel myErrorLabel;
    JPanel myLinkAndErrorPanel;
    JButton myCreateButton;
    JPanel myMainPanel;
    LabeledComponent<TextFieldWithBrowseButton> myLocation;
    ActionListener myCloseActionListener;
    JBScrollPane myScrollPane;
    final YeomanGlobalSettings myYeomanGlobalSettings;
    YeomanProjectGeneratorOwnerPanel.ValidateHandler myValidateHandler;
    @Nullable
    YeomanProjectGeneratorSubPanel mySubPanel;

    public boolean isEnable() {
        return this.mySubPanel == null || this.mySubPanel.isCreateButtonEnabled();
    }

    public YeomanProjectGenerator.Settings getSettings() {
        return this.mySettings;
    }

    public YeomanProjectGeneratorPanel(YeomanProjectGenerator.Settings path) {
        this.mySettings = path;
        this.myYeomanGlobalSettings = YeomanGlobalSettings.getInstance();
    }

    @Nullable
    public String validate() {
        if (this.mySubPanel != null) {
            return this.mySubPanel.validate();
        }
        return null;
    }

    @NotNull
    private static JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel(new BorderLayout());
        JLabel title = new JLabel("New project");
        title.setFont(title.getFont().deriveFont(1));
        titlePanel.add((Component)title, "West");
        titlePanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)10, (int)0));
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "createTitlePanel"));
        }
        return jPanel;
    }

    public void init(@NotNull LabeledComponent<TextFieldWithBrowseButton> location, @NotNull JLabel errorLabel, @NotNull JButton createButton, ActionListener closeActionListener) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "init"));
        }
        if (errorLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLabel", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "init"));
        }
        if (createButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createButton", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "init"));
        }
        this.myCloseActionListener = closeActionListener;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myLocation = location;
        this.myErrorLabel = errorLabel;
        this.myScrollPane = YeomanProjectGeneratorPanel.createScrollPane();
        this.myMainPanel.add((Component)this.myScrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.myCreateButton = createButton;
        this.myCreateButton.setText("Next");
        this.myCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YeomanProjectGeneratorPanel.this.mySubPanel != null) {
                    YeomanProjectGeneratorPanel.this.mySubPanel = YeomanProjectGeneratorPanel.this.mySubPanel.next(e);
                    YeomanProjectGeneratorPanel.this.mySubPanel.render();
                }
            }
        });
        this.myLinkAndErrorPanel = new JPanel(new BorderLayout(10, 0));
        this.myLinkAndErrorPanel.add((Component)this.myErrorLabel, "West");
        bottomPanel.add((Component)this.myLinkAndErrorPanel, "West");
        bottomPanel.add((Component)this.myCreateButton, "East");
        this.myMainPanel.add((Component)bottomPanel, "South");
        JPanel titlePanel = YeomanProjectGeneratorPanel.createTitlePanel();
        this.myMainPanel.add((Component)titlePanel, "North");
    }

    public static JBScrollPane createScrollPane() {
        JBScrollPane scrollPane = new JBScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    public void showFirstStep() {
        this.mySubPanel = new YeomanProjectGeneratorWelcomePanel(this, this.mySettings);
        this.mySubPanel.render();
    }

    @Override
    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "getMainPanel"));
        }
        return jPanel;
    }

    public void setValidateHandler(YeomanProjectGeneratorOwnerPanel.ValidateHandler handler) {
        this.myValidateHandler = handler;
    }

    public void dispose() {
        if (this.mySubPanel != null) {
            Disposer.dispose((Disposable)this.mySubPanel);
            UIUtil.invokeLaterIfNeeded(() -> this.showFirstStep());
        }
    }

    @Override
    @Nullable
    public YeomanProjectGeneratorOwnerPanel.ValidateHandler getValidateHandler() {
        return this.myValidateHandler;
    }

    @Override
    public void setCentralComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "setCentralComponent"));
        }
        this.myScrollPane.setViewportView((Component)component);
    }

    @Override
    public void setBottomComponent(JComponent component) {
        this.myLinkAndErrorPanel.add((Component)component, "Center");
    }

    @Override
    public void setMainButtonEnable(boolean isEnable) {
        this.myCreateButton.setEnabled(isEnable);
    }

    @Override
    @NotNull
    public String getLocationTitle() {
        String string = ((TextFieldWithBrowseButton)this.myLocation.getComponent()).getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "getLocationTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    public LabeledComponent<TextFieldWithBrowseButton> getLocationComponent() {
        return this.myLocation;
    }

    @Override
    public void close(ActionEvent e) {
        this.myCloseActionListener.actionPerformed(e);
    }

    @Override
    public void setMainButtonName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorPanel", "setMainButtonName"));
        }
        this.myCreateButton.setName(newName);
    }
}

