/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.template;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGenerator;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorOwnerPanel;
import jetbrains.plugins.yeoman.projectGenerator.template.YeomanProjectGeneratorSubPanel;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanProjectGeneratorRunPanel
implements YeomanProjectGeneratorSubPanel {
    private final YeomanProjectGeneratorOwnerPanel myOwner;
    private final YeomanProjectGenerator.Settings mySettings;
    private final JBCheckBox myCheckBox;
    private YeomanRunGeneratorForm myForm;
    private boolean myNextClose = false;
    private boolean myIsRendered = false;
    private boolean myIsEnable = true;

    public boolean isReadyToClose() {
        return this.myNextClose;
    }

    public YeomanProjectGeneratorRunPanel(YeomanProjectGeneratorOwnerPanel owner, YeomanProjectGenerator.Settings settings) {
        this.myOwner = owner;
        this.mySettings = settings;
        this.myCheckBox = new JBCheckBox("<html>Run <b>npm</b> install & <b>bower</b> install");
        this.myCheckBox.setSelected(true);
    }

    public boolean isRendered() {
        return this.myIsRendered;
    }

    @Override
    public void render() {
        if (!this.myIsRendered) {
            YeomanInstalledGeneratorInfo info = this.mySettings.info;
            YeomanRunGeneratorForm.EventHandler handler = new YeomanRunGeneratorForm.EventHandler(){

                @Override
                public void handleEvent(YeomanRunGeneratorForm.EventTypes event) {
                    switch (event) {
                        case RENDERED: {
                            YeomanProjectGeneratorRunPanel.this.myIsEnable = true;
                            YeomanProjectGeneratorRunPanel.this.myOwner.setMainButtonEnable(true);
                            break;
                        }
                        case STARTING_ERROR: 
                        case TERMINATED_OK: 
                        case TERMINATED_ERROR: {
                            YeomanProjectGeneratorRunPanel.this.myOwner.setMainButtonEnable(true);
                            YeomanProjectGeneratorRunPanel.this.myOwner.setMainButtonName("Complete");
                            YeomanProjectGeneratorRunPanel.this.myNextClose = true;
                            if (YeomanProjectGeneratorRunPanel.this.myForm == null) break;
                            JPanel wrapper = new JPanel(new BorderLayout());
                            wrapper.add((Component)YeomanProjectGeneratorRunPanel.this.myCheckBox, "North");
                            YeomanProjectGeneratorRunPanel.this.myForm.getHolderPanel().setViewportView(wrapper);
                        }
                    }
                }
            };
            this.myForm = new YeomanRunGeneratorForm(this.mySettings.appPath, null, YeomanGlobalSettings.getInstance(), info, handler, this.mySettings.options);
            this.myOwner.setCentralComponent(this.myForm.getMainPanel());
            this.myIsRendered = true;
        }
    }

    @Override
    @Nullable
    public String validate() {
        return null;
    }

    @Override
    @NotNull
    public YeomanProjectGeneratorSubPanel next(@Nullable ActionEvent e) {
        if (!this.isReadyToClose()) {
            this.myIsEnable = false;
            this.myOwner.setMainButtonEnable(false);
            this.myForm.next();
        } else {
            this.commitSettings();
            this.myOwner.close(e);
        }
        YeomanProjectGeneratorRunPanel yeomanProjectGeneratorRunPanel = this;
        if (yeomanProjectGeneratorRunPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/template/YeomanProjectGeneratorRunPanel", "next"));
        }
        return yeomanProjectGeneratorRunPanel;
    }

    @Override
    public void commitSettings() {
        this.mySettings.runNpmAndBowerInstall = this.myCheckBox.isSelected();
    }

    @Override
    public boolean isCreateButtonEnabled() {
        return this.myIsEnable;
    }

    public void dispose() {
        if (this.myForm != null) {
            Disposer.dispose((Disposable)this.myForm);
        }
    }
}

