/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorListProvider;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorsMain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanAvailableGeneratorsMain
extends YeomanGeneratorsMain {
    private final YeomanGeneratorListProvider myProvider;
    private Map<String, YeomanInstalledGeneratorInfo> myInstalledGenerators;
    private boolean myBusy;

    public YeomanAvailableGeneratorsMain(@NotNull List<YeomanInstalledGeneratorInfo> installedGenerators, YeomanGeneratorListProvider provider) {
        if (installedGenerators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedGenerators", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanAvailableGeneratorsMain", "<init>"));
        }
        this.myBusy = false;
        this.myProvider = provider;
        this.setInstalledGenerators(installedGenerators);
        this.myFilter = new YeomanGeneratorsMain.MyPluginsFilter(this);
        this.init(true);
        this.main.setPreferredSize(new Dimension(550, 400));
    }

    public void setInstalledGenerators(@NotNull List<YeomanInstalledGeneratorInfo> installedGenerators) {
        if (installedGenerators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedGenerators", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanAvailableGeneratorsMain", "setInstalledGenerators"));
        }
        this.myInstalledGenerators = ContainerUtil.map2MapNotNull(installedGenerators, info -> Pair.create((Object)info.getName(), (Object)info));
    }

    @Override
    protected ActionGroup getActionGroup(boolean b) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new DumbAwareAction("Reload List of Generators", "Reload list of generators", AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                YeomanAvailableGeneratorsMain.this.myBusy = true;
                YeomanAvailableGeneratorsMain.this.downloadAndShowGeneratorList();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!YeomanAvailableGeneratorsMain.this.myBusy);
            }
        });
        return actionGroup;
    }

    public void downloadAndShowGeneratorList() {
        YeomanGeneratorInfo generator = this.getSelectedObject();
        Ref generators = new Ref(null);
        Ref hasErrors = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                try {
                    List<YeomanGeneratorFullInfo> providedGenerators = this.myProvider.getAvailableGenerators(true);
                    generators.set(providedGenerators);
                }
                catch (RuntimeException e) {
                    hasErrors.set((Object)true);
                }
            }
            finally {
                this.myBusy = false;
            }
        }, YeomanBundle.message("yeoman.generators.dialog.available.list.download.title", new Object[0]), true, null, (JComponent)this.main);
        if (this.myFilter != null) {
            this.myFilter.setFilter("");
        }
        List list = ContainerUtil.notNullize((List)((List)generators.get()));
        YeomanGeneratorFullInfo newSelected = null;
        for (YeomanGeneratorFullInfo info : list) {
            if (!info.equals(generator)) continue;
            newSelected = info;
        }
        this.setAvailableGenerators(list);
        this.select(newSelected);
        this.handleUpdate();
        if (((Boolean)hasErrors.get()).booleanValue()) {
            Messages.showErrorDialog((Component)this.getMainPanel(), (String)YeomanBundle.message("yeoman.generators.dialog.download.error", new Object[0]));
        }
    }

    public void setAvailableGenerators(List<YeomanGeneratorFullInfo> availableGenerators) {
        this.myModel.setAllViews(availableGenerators);
    }

    @Override
    @Nullable
    public YeomanInstalledGeneratorInfo getInstalledGeneratorInfo(@Nullable YeomanGeneratorInfo info) {
        if (info == null) {
            return null;
        }
        YeomanInstalledGeneratorInfo installedGeneratorInfo = this.myInstalledGenerators.get(info.getName());
        return installedGeneratorInfo != null ? installedGeneratorInfo : super.getInstalledGeneratorInfo(info);
    }
}

