/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBGradientPaint;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import icons.YeomanIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInstaller;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorsMain;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorInfoPanelHeader {
    private final JBPanel myRootPanel;
    private final JBLabel myGeneratorHeaderLabel;
    private final YeomanGeneratorsMain myParent;
    private final boolean myHasInstallButton;
    private YeomanGeneratorInfo myInfo;
    private final JButton myActionButton;
    private final JPanel myStartsHolder;
    private State myState = State.AVAILABLE;

    public YeomanGeneratorInfoPanelHeader(YeomanGeneratorsMain parent, boolean allAvailable) {
        this.myParent = parent;
        this.myHasInstallButton = allAvailable;
        this.myRootPanel = new JBPanel((LayoutManager)new VerticalLayout(5, 2));
        this.myRootPanel.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myGeneratorHeaderLabel = new JBLabel();
        this.myGeneratorHeaderLabel.setFont(UIUtil.getLabelFont());
        UIUtil.addBorder((JComponent)this.myGeneratorHeaderLabel, (Border)IdeBorderFactory.createEmptyBorder((int)12, (int)0, (int)0, (int)0));
        this.myRootPanel.add((Component)this.myGeneratorHeaderLabel);
        this.myActionButton = this.createActionButton();
        RelativeFont.BOLD.install((Component)this.myGeneratorHeaderLabel);
        this.myRootPanel.add((Component)this.myActionButton);
        this.myActionButton.setVisible(false);
        this.myStartsHolder = new JPanel(new BorderLayout());
        this.myStartsHolder.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.add((Component)this.myStartsHolder);
    }

    private JButton createActionButton() {
        JButton actionButton = new JButton(){
            {
                this.setOpaque(false);
                this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public Dimension getPreferredSize() {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                int textWidth = metrics.stringWidth(this.getText());
                int width = 40 + textWidth;
                int height = 10 + Math.max(16, metrics.getHeight());
                return new Dimension(width, height);
            }

            @Override
            public void paint(Graphics g2) {
                Graphics2D g = (Graphics2D)g2;
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                int w = g.getClipBounds().width;
                int h = g.getClipBounds().height;
                g.setPaint(this.getBackgroundBorderPaint());
                g.fillRoundRect(0, 0, w, h, 7, 7);
                g.setPaint(this.getBackgroundPaint());
                g.fillRoundRect(1, 1, w - 2, h - 2, 6, 6);
                g.setColor(this.getButtonForeground());
                g.drawString(this.getText(), 28, this.getBaseline(w, h));
                this.getIcon().paintIcon(this, g, 8, (this.getHeight() - this.getIcon().getIconHeight()) / 2);
                config.restore();
            }

            private Color getButtonForeground() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return new JBColor((Color)Gray._240, (Color)Gray._210);
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return new JBColor((Color)Gray._0, (Color)Gray._210);
                    }
                }
                return new JBColor((Color)Gray._80, (Color)Gray._60);
            }

            private Paint getBackgroundPaint() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return new JBGradientPaint((JComponent)this, (Color)new JBColor(new Color(96, 204, 105), new Color(81, 149, 87)), (Color)new JBColor(new Color(50, 101, 41), new Color(40, 70, 47)));
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return UIUtil.isUnderDarcula() ? new JBGradientPaint((JComponent)this, UIManager.getColor("Button.darcula.color1"), UIManager.getColor("Button.darcula.color2")) : Gray._240;
                    }
                }
                return Gray._238;
            }

            private Paint getBackgroundBorderPaint() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return new JBColor(new Color(201, 223, 201), (Color)Gray._70);
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return new JBColor((Color)Gray._220, Gray._100.withAlpha(180));
                    }
                }
                return Gray._208;
            }

            @Override
            public String getText() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return YeomanBundle.message("yeoman.generators.dialog.install.generator", new Object[0]);
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return YeomanBundle.message("yeoman.generators.dialog.uninstall.generator", new Object[0]);
                    }
                }
                return super.getText();
            }

            @Override
            public Icon getIcon() {
                switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                    case AVAILABLE: {
                        return AllIcons.General.DownloadPlugin;
                    }
                    case GLOBAL_INSTALLED: 
                    case LOCAL_INSTALLED: {
                        return AllIcons.Actions.Delete;
                    }
                }
                return super.getIcon();
            }
        };
        actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YeomanGeneratorInfo yeomanGeneratorInfo = YeomanGeneratorInfoPanelHeader.this.myInfo;
                if (yeomanGeneratorInfo != null) {
                    boolean updated = false;
                    switch (YeomanGeneratorInfoPanelHeader.this.myState) {
                        case AVAILABLE: {
                            try {
                                updated = null != YeomanGeneratorInstaller.getInstance().install(yeomanGeneratorInfo, YeomanGlobalSettings.getInstance());
                            }
                            catch (RuntimeException ex) {
                                Messages.showErrorDialog((Component)YeomanGeneratorInfoPanelHeader.this.myParent.getMainPanel(), (String)(YeomanBundle.message("yeoman.generators.dialog.install.error", new Object[0]) + " " + yeomanGeneratorInfo.getName()));
                            }
                            break;
                        }
                        case GLOBAL_INSTALLED: 
                        case LOCAL_INSTALLED: {
                            if (0 != Messages.showYesNoDialog((Component)YeomanGeneratorInfoPanelHeader.this.myParent.getMainPanel(), (String)YeomanBundle.message("yeoman.generators.prompt.uninstall", yeomanGeneratorInfo.getName()), (String)YeomanBundle.message("yeoman.generators.prompt.uninstall.title", new Object[0]), (Icon)Messages.getQuestionIcon())) {
                                return;
                            }
                            YeomanInstalledGeneratorInfo installedGeneratorInfo = YeomanGeneratorInfoPanelHeader.this.myParent.getInstalledGeneratorInfo(YeomanGeneratorInfoPanelHeader.this.myInfo);
                            if (installedGeneratorInfo == null) break;
                            updated = YeomanGeneratorInstaller.getInstance().uninstall(installedGeneratorInfo);
                            break;
                        }
                    }
                    if (updated) {
                        YeomanGeneratorInfoPanelHeader.this.myParent.handleUpdate();
                        YeomanGeneratorInfoPanelHeader.this.myParent.select(yeomanGeneratorInfo);
                    }
                }
            }
        });
        return actionButton;
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void updateInfo(YeomanGeneratorInfo info) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myInfo = info;
        this.myRootPanel.setVisible(true);
        this.myGeneratorHeaderLabel.setText(info == null ? "no info" : info.getName());
        this.myActionButton.setVisible(false);
        this.myState = this.getState(info);
        if (this.myInfo != null) {
            this.myActionButton.setVisible(this.myHasInstallButton && this.myState != State.GLOBAL_INSTALLED && this.myState != State.INCORRECT);
            YeomanGeneratorFullInfo fullInfo = this.myParent.getFullGeneratorInfo(info);
            this.myStartsHolder.removeAll();
            if (fullInfo == null) {
                this.myStartsHolder.setVisible(false);
            } else {
                this.myStartsHolder.setVisible(true);
                this.myStartsHolder.add(YeomanGeneratorInfoPanelHeader.createPanelWithStartsGithubAndRemoveButton(fullInfo));
            }
        }
    }

    @NotNull
    private State getState(YeomanGeneratorInfo info) {
        if (YeomanGlobalSettings.getInstance().getInterpreter() == null) {
            State state = State.INCORRECT;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "getState"));
            }
            return state;
        }
        YeomanInstalledGeneratorInfo installInfo = this.myParent.getInstalledGeneratorInfo(info);
        if (installInfo == null) {
            State state = State.AVAILABLE;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "getState"));
            }
            return state;
        }
        State state = installInfo.isGlobal() ? State.GLOBAL_INSTALLED : State.LOCAL_INSTALLED;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "getState"));
        }
        return state;
    }

    @Nullable
    private static JComponent createStarsLabel(@NotNull YeomanGeneratorFullInfo fullInfo) {
        if (fullInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullInfo", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "createStarsLabel"));
        }
        int stars = fullInfo.getStars();
        if (stars > 0) {
            JBLabel label = new JBLabel(String.valueOf(stars), YeomanIcons.Rating0, 2);
            label.setFont(UIUtil.getLabelFont());
            return label;
        }
        return null;
    }

    @Nullable
    private static JComponent createOnGithub(@NotNull YeomanGeneratorFullInfo fullInfo) {
        if (fullInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullInfo", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "createOnGithub"));
        }
        String text = fullInfo.getWebsite();
        if (!StringUtil.isEmpty((String)text)) {
            JEditorPane pane = new JEditorPane("text/html", "");
            pane.setEditable(false);
            pane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
            StringBuilder builder = new StringBuilder("<a href=\"" + text + "\">on GitHub</a>");
            YeomanGeneratorsMain.setTextValue(builder, null, pane);
            return pane;
        }
        return null;
    }

    private static JPanel createPanelWithStartsGithubAndRemoveButton(@NotNull YeomanGeneratorFullInfo fullInfo) {
        JComponent github;
        if (fullInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullInfo", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanGeneratorInfoPanelHeader", "createPanelWithStartsGithubAndRemoveButton"));
        }
        JPanel result = new JPanel((LayoutManager)new HorizontalLayout(1, 0));
        result.setBorder(IdeBorderFactory.createEmptyBorder());
        result.setBackground(UIUtil.getTextFieldBackground());
        JComponent label = YeomanGeneratorInfoPanelHeader.createStarsLabel(fullInfo);
        if (label != null) {
            result.add(label);
        }
        if ((github = YeomanGeneratorInfoPanelHeader.createOnGithub(fullInfo)) != null) {
            result.add(github);
        }
        return result;
    }

    static enum State {
        AVAILABLE,
        LOCAL_INSTALLED,
        GLOBAL_INSTALLED,
        INCORRECT;

    }
}

