/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.list;

import com.intellij.CommonBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorFullInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanGeneratorListProvider;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorListProvider;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanAvailableGeneratorsMain;
import jetbrains.plugins.yeoman.projectGenerator.ui.list.YeomanGeneratorsMain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanInstalledGeneratorsMain
extends YeomanGeneratorsMain {
    private List<YeomanInstalledGeneratorInfo> myInstalledGenerators;
    private final JButton myInstallGenerators;
    private YeomanGeneratorListProvider myProvider = new YeomanGeneratorListProvider();

    public void setInstalledGenerators(List<YeomanInstalledGeneratorInfo> installedGenerators) {
        this.myInstalledGenerators = installedGenerators;
        this.myModel.setAllViews(this.myInstalledGenerators);
    }

    public JButton getInstallGeneratorsButton() {
        return this.myInstallGenerators;
    }

    public YeomanInstalledGeneratorsMain() {
        this.init(false);
        this.myInstalledGenerators = new YeomanInstalledGeneratorListProvider().getAllInstalledGenerators();
        this.myModel.setAllViews(this.myInstalledGenerators);
        this.myInstallGenerators = new JButton(YeomanBundle.message("yeoman.generators.dialog.install.generators", new Object[0]));
        this.myInstallGenerators.setMnemonic('j');
        this.myInstallGenerators.addActionListener(this.createInstallGeneratorsActionListener());
        this.myInstallGenerators.setMargin(new Insets(0, 0, 0, 0));
        if (this.myInstalledGenerators.size() > 0) {
            this.myGeneratorTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        this.myToolbarPanel.setVisible(false);
    }

    private ActionListener createInstallGeneratorsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogWrapper wrapper = new DialogWrapper(YeomanInstalledGeneratorsMain.this.main, true){
                    {
                        this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
                        this.setOKButtonMnemonic(67);
                        this.init();
                    }

                    @NotNull
                    protected Action[] createActions() {
                        Action[] actionArray = new Action[]{this.getOKAction()};
                        if (actionArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/list/YeomanInstalledGeneratorsMain$1$1", "createActions"));
                        }
                        return actionArray;
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        YeomanAvailableGeneratorsMain availableGeneratorsMain = new YeomanAvailableGeneratorsMain(YeomanInstalledGeneratorsMain.this.myInstalledGenerators, YeomanInstalledGeneratorsMain.this.myProvider){

                            @Override
                            public void handleUpdate() {
                                YeomanInstalledGeneratorsMain installedGeneratorMain = YeomanInstalledGeneratorsMain.this;
                                List<YeomanInstalledGeneratorInfo> generators = YeomanInstalledGeneratorListProvider.getProvider().getAllInstalledGenerators();
                                YeomanGeneratorInfo selected = installedGeneratorMain.getSelectedObject();
                                installedGeneratorMain.setInstalledGenerators(generators);
                                YeomanGeneratorsMain.MyPluginsFilter parentFilter = installedGeneratorMain.myFilter;
                                if (parentFilter != null) {
                                    installedGeneratorMain.myModel.filter(parentFilter.getFilterLowerCase());
                                }
                                if (selected instanceof YeomanInstalledGeneratorInfo && generators.contains(selected)) {
                                    installedGeneratorMain.select(selected);
                                } else {
                                    installedGeneratorMain.select((YeomanGeneratorInfo)ContainerUtil.getFirstItem(generators));
                                }
                                this.setInstalledGenerators(generators);
                                this.repaint();
                            }
                        };
                        if (YeomanInstalledGeneratorsMain.this.myProvider.isAvailableGeneratorListExists()) {
                            availableGeneratorsMain.myModel.setAllViews(YeomanInstalledGeneratorsMain.this.myProvider.getAvailableGenerators(false));
                        } else {
                            availableGeneratorsMain.downloadAndShowGeneratorList();
                        }
                        return availableGeneratorsMain.getMainPanel();
                    }
                };
                wrapper.show();
            }
        };
    }

    @Override
    @Nullable
    public YeomanGeneratorFullInfo getFullGeneratorInfo(@Nullable YeomanGeneratorInfo info) {
        if (info instanceof YeomanGeneratorFullInfo || info == null) {
            return (YeomanGeneratorFullInfo)info;
        }
        if (this.myProvider.isAvailableGeneratorListExists()) {
            for (YeomanGeneratorFullInfo fullInfo : this.myProvider.getAvailableGenerators(false)) {
                if (!StringUtil.equals((CharSequence)fullInfo.getName(), (CharSequence)info.getName())) continue;
                return fullInfo;
            }
        }
        return null;
    }
}

