/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.run;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanRunGeneratorDialog
extends DialogWrapper {
    private final VirtualFile myToProcess;
    @Nullable
    private final YeomanInstalledGeneratorInfo myInfo;
    private Action myRealOkAction;
    private boolean myToClose;
    private YeomanRunGeneratorForm myForm;
    private final Project myProject;

    public YeomanRunGeneratorForm getForm() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myForm;
    }

    public YeomanRunGeneratorDialog(@NotNull Project project, @NotNull VirtualFile toProcess, @Nullable YeomanInstalledGeneratorInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorDialog", "<init>"));
        }
        if (toProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toProcess", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorDialog", "<init>"));
        }
        super(false);
        this.myToProcess = toProcess;
        this.myInfo = info;
        this.setTitle(YeomanBundle.message("yeoman.generator.run.action.title", new Object[0]));
        this.myProject = project;
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        YeomanRunGeneratorForm.EventHandler close = new YeomanRunGeneratorForm.EventHandler(){

            @Override
            public void handleEvent(YeomanRunGeneratorForm.EventTypes event) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    switch (event) {
                        case RENDERED: {
                            YeomanRunGeneratorDialog.this.getOKAction().setEnabled(true);
                            break;
                        }
                        case TERMINATED_OK: 
                        case TERMINATED_ERROR: {
                            YeomanRunGeneratorDialog.this.getOKAction().setEnabled(true);
                            YeomanRunGeneratorDialog.this.getOKAction().putValue("Name", YeomanBundle.message("yeoman.generator.run.action.close", new Object[0]));
                            YeomanRunGeneratorDialog.this.getCancelAction().setEnabled(false);
                            YeomanRunGeneratorDialog.this.myToClose = true;
                            break;
                        }
                    }
                });
            }
        };
        this.myForm = new YeomanRunGeneratorForm(this.myToProcess.getCanonicalPath(), this.myProject, YeomanGlobalSettings.getInstance(), this.myInfo, close, null){

            @Override
            protected boolean hasWelcome() {
                return true;
            }
        };
        return this.myForm.getMainPanel();
    }

    protected void createDefaultActions() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.createDefaultActions();
        this.myRealOkAction = this.myOKAction;
        this.myOKAction = new AbstractAction(YeomanBundle.message("yeoman.generator.run.action.next", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (YeomanRunGeneratorDialog.this.myToClose) {
                    YeomanRunGeneratorDialog.this.myRealOkAction.actionPerformed(e);
                    YeomanRunGeneratorDialog.this.myToProcess.refresh(true, true);
                    return;
                }
                YeomanRunGeneratorDialog.this.getOKAction().setEnabled(false);
                YeomanRunGeneratorDialog.this.myForm.next();
            }
        };
    }
}

