/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorInfo;
import jetbrains.plugins.yeoman.generators.YeomanInstalledGeneratorListProvider;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanStepFormRenderer;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControl;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanRunGeneratorForm
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance(YeomanRunGeneratorForm.class);
    private final Project myProject;
    private final YeomanGlobalSettings mySettings;
    private final AsyncProcessIcon myAsyncProcessIcon;
    private JTextField myGeneratorOptions;
    @Nullable
    private YeomanInstalledGeneratorInfo myInfo;
    private final String myDirectoryForCreate;
    private final EventHandler myGlobalEventHandler;
    private JScrollPane myScrollPane;
    private JPanel myMainPanel;
    private JPanel myFormContainerPanel;
    private JLabel myGeneratorTitle;
    private JPanel myConsolePanel;
    private JPanel myTopRunningLabelPanel;
    private KillableColoredProcessHandler myProcessHandler;
    private YeomanStepFormRenderer myRenderer;
    private YeomanGeneratorControl.YeomanGeneratorControlUI myCurrentControl;
    private OutputStream myInput;
    private int mySteps = 0;
    private ConsoleViewImpl myConsoleView;
    private JTextField myGeneratorNameField;

    public YeomanRunGeneratorForm(String directoryForCreate, @Nullable Project project, YeomanGlobalSettings settings, @Nullable YeomanInstalledGeneratorInfo info, EventHandler handler, @Nullable String options) {
        this.myDirectoryForCreate = directoryForCreate;
        this.myGlobalEventHandler = handler;
        this.$$$setupUI$$$();
        this.myConsolePanel.setVisible(false);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myMainPanel);
        this.myProject = project == null ? DefaultProjectFactory.getInstance().getDefaultProject() : project;
        this.mySettings = settings;
        this.myInfo = info;
        this.myRenderer = new YeomanStepFormRenderer();
        this.myAsyncProcessIcon = new AsyncProcessIcon("");
        this.myTopRunningLabelPanel.add((Component)this.myAsyncProcessIcon);
        this.renderWelcomeForm();
        this.myGeneratorOptions.setText(options);
        if (!this.hasWelcome()) {
            this.next();
        }
    }

    protected boolean hasWelcome() {
        return false;
    }

    public void renderWelcomeForm() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myGeneratorNameField = this.createGeneratorNameField();
        builder.addLabeledComponent("Generator name:", (JComponent)this.myGeneratorNameField);
        this.myGeneratorOptions = new JTextField();
        builder.addLabeledComponent("Generator options:", (JComponent)this.myGeneratorOptions);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)builder.getPanel(), "North");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)wrapper, (boolean)true);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myFormContainerPanel.add((Component)this.myScrollPane, "Center");
        this.myGeneratorTitle.setFont(UIUtil.getLabelFont());
        RelativeFont.ITALIC.install((Component)this.myGeneratorTitle);
        this.myGeneratorTitle.setText("Generator settings");
    }

    public void startGeneratorApp() {
        GeneralCommandLine commandLine = this.createCommandLine();
        try {
            this.myProcessHandler = new KillableColoredProcessHandler(commandLine);
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String text;
                    LOGGER.debug(event.getText());
                    if (outputType == ProcessOutputTypes.STDOUT && (text = StringUtil.notNullize((String)event.getText()).trim()).contains("{") && text.endsWith("}") && !text.startsWith("--debug")) {
                        YeomanRunGeneratorForm.this.renderStepForm(text.substring(text.indexOf("{")));
                    }
                }

                public void processTerminated(ProcessEvent event) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        YeomanRunGeneratorForm.this.done();
                        YeomanRunGeneratorForm.this.myGlobalEventHandler.handleEvent(event.getExitCode() == 0 ? EventTypes.TERMINATED_OK : EventTypes.TERMINATED_ERROR);
                    });
                }
            });
            this.myProcessHandler.startNotify();
            this.myInput = this.myProcessHandler.getProcessInput();
            this.myConsoleView = new ConsoleViewImpl(this.myProject, true){

                public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                    if (s == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorForm$2", "print"));
                    }
                    if (contentType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorForm$2", "print"));
                    }
                    if (contentType == ConsoleViewContentType.ERROR_OUTPUT || LOGGER.isDebugEnabled()) {
                        super.print(s, contentType);
                    }
                }
            };
            this.myConsoleView.attachToProcess((ProcessHandler)this.myProcessHandler);
            this.myConsoleView.setPreferredSize(new Dimension(550, 150));
        }
        catch (ExecutionException e) {
            this.myGlobalEventHandler.handleEvent(EventTypes.STARTING_ERROR);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void renderStepForm(String text) {
        UIUtil.invokeLaterIfNeeded(() -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myCurrentControl = this.myRenderer.render(text);
            assert (this.myInfo != null);
            this.myGeneratorTitle.setText("Running \"" + this.myInfo.getYoName() + "\" generator:  Step " + ++this.mySteps);
            JComponent component = this.myCurrentControl.getComponent();
            JPanel wrapper = new JPanel(new BorderLayout());
            wrapper.add((Component)component, "North");
            UIUtil.setEnabled((Component)this.myScrollPane, (boolean)true, (boolean)true);
            this.myScrollPane.setViewportView(wrapper);
            this.myAsyncProcessIcon.setVisible(false);
            this.myGlobalEventHandler.handleEvent(EventTypes.RENDERED);
        });
    }

    private void showConsole() {
        JComponent consoleComponent = this.myConsoleView.getComponent();
        HideableDecorator decorator = new HideableDecorator(this.myConsolePanel, "Yeoman console output", false);
        decorator.setContentComponent(consoleComponent);
        decorator.setOn(false);
        this.myConsolePanel.setVisible(true);
    }

    private GeneralCommandLine createCommandLine() {
        NodeJsLocalInterpreter interpreter = this.mySettings.getInterpreter();
        assert (interpreter != null);
        GeneralCommandLine line = new GeneralCommandLine(new String[]{interpreter.getInterpreterSystemIndependentPath()});
        assert (this.myInfo != null);
        line.withWorkDirectory(this.myDirectoryForCreate);
        line.setCharset(CharsetToolkit.UTF8_CHARSET);
        line.addParameter(this.mySettings.getCLIHelperPath());
        line.addParameter("--generatorName");
        line.addParameter(this.myInfo.getYoName());
        line.addParameter("--generatorPath");
        line.addParameter(this.myInfo.getFilePath());
        line.addParameter("--yeoman");
        line.addParameter(this.mySettings.getYoPackagePath());
        String options = this.myGeneratorOptions.getText();
        if (!StringUtil.isEmpty((String)options)) {
            line.addParameter("--arguments");
            line.addParameter(options);
        }
        if (LOGGER.isDebugEnabled()) {
            line.addParameter("--debug");
        }
        return line;
    }

    @NotNull
    private JTextField createGeneratorNameField() {
        JTextField field = new JTextField();
        if (this.myInfo != null) {
            field.setText(this.myInfo.getYoName());
            field.setEnabled(false);
        }
        JTextField jTextField = field;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorForm", "createGeneratorNameField"));
        }
        return jTextField;
    }

    @NotNull
    public JScrollPane getHolderPanel() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorForm", "getHolderPanel"));
        }
        return jScrollPane;
    }

    public void next() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAsyncProcessIcon.setVisible(true);
        if (this.myCurrentControl != null) {
            this.send(this.myCurrentControl.getSelectedValue());
            UIUtil.setEnabled((Component)this.myScrollPane, (boolean)false, (boolean)true);
        }
        if (this.myProcessHandler == null) {
            this.myInfo = new YeomanInstalledGeneratorListProvider().getGeneratorByYoName(this.myGeneratorNameField.getText());
            if (this.myInfo != null) {
                this.myGeneratorTitle.setText("Running \"" + this.myInfo.getYoName() + "\" generator");
                this.startGeneratorApp();
                UIUtil.setEnabled((Component)this.myScrollPane, (boolean)true, (boolean)true);
                this.myScrollPane.setViewportView(new JPanel(new BorderLayout()));
                this.showConsole();
            }
        }
    }

    private void done() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myGeneratorTitle.setText("Complete \"" + this.myInfo.getYoName() + "\" generator");
        this.myAsyncProcessIcon.setVisible(false);
        this.myScrollPane.setViewportView(new JPanel(new BorderLayout()));
    }

    @NotNull
    public JComponent getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanRunGeneratorForm", "getMainPanel"));
        }
        return jPanel;
    }

    public void dispose() {
        if (this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated() && !this.myProcessHandler.isProcessTerminating()) {
            LOGGER.debug("Dispose process " + this.myProcessHandler.getCommandLine());
            this.myProcessHandler.destroyProcess();
            try {
                File file = new File(this.myDirectoryForCreate);
                if (file.exists()) {
                    FileUtil.delete((File)file);
                }
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            if (SystemInfo.isWindows) {
                this.myProcessHandler.killProcess();
            }
        }
        if (this.myConsoleView != null) {
            Disposer.dispose((Disposable)this.myConsoleView);
        }
    }

    private void send(String message) {
        if (this.myInput != null) {
            try {
                if (!message.endsWith("\n")) {
                    message = message + "\n";
                }
                this.myInput.write(message.getBytes(CharsetToolkit.UTF8_CHARSET));
                this.myInput.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setPreferredSize(new Dimension(550, 310));
        this.myFormContainerPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConsolePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null, 1));
        this.myTopRunningLabelPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 5));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myGeneratorTitle = jLabel = new JLabel();
        jLabel.setText("Label");
        Component component = jPanel.add(jLabel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface EventHandler {
        public void handleEvent(EventTypes var1);
    }

    public static enum EventTypes {
        RENDERED,
        TERMINATED_OK,
        TERMINATED_ERROR,
        STARTING_ERROR;

    }
}

