/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.run;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.YeomanRunGeneratorForm;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorCheckboxControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorConformControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorInputControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorListControl;
import org.jetbrains.annotations.NotNull;

public class YeomanStepFormRenderer {
    public static final Logger LOGGER = Logger.getInstance(YeomanRunGeneratorForm.class);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(YeomanGeneratorListControl.Choice.class, (Object)new YeomanGeneratorListControl.Adapter()).registerTypeAdapter(YeomanGeneratorCheckboxControl.Choice.class, (Object)new YeomanGeneratorCheckboxControl.Adapter()).create();
    public static final String FIELD_TYPE = "type";
    public static final String TYPE_CONFORM = "confirm";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_EXPAND = "expand";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_RAWLIST = "rawlist";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_PASSWORD = "password";
    public static final Map<String, Class<? extends YeomanGeneratorControl>> CONTROLS = ContainerUtil.newHashMap((Pair)Pair.create((Object)"confirm", YeomanGeneratorConformControl.class), (Pair[])new Pair[]{Pair.create((Object)"checkbox", YeomanGeneratorCheckboxControl.class), Pair.create((Object)"expand", YeomanGeneratorListControl.class), Pair.create((Object)"list", YeomanGeneratorListControl.class), Pair.create((Object)"rawlist", YeomanGeneratorListControl.class), Pair.create((Object)"input", YeomanGeneratorInputControl.class), Pair.create((Object)"password", YeomanGeneratorInputControl.class)});

    public YeomanGeneratorControl.YeomanGeneratorControlUI render(@NotNull String json) {
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "jetbrains/plugins/yeoman/projectGenerator/ui/run/YeomanStepFormRenderer", "render"));
        }
        try {
            JsonElement parse = new JsonParser().parse(json);
            assert (parse.isJsonObject());
            JsonElement typeElement = parse.getAsJsonObject().get(FIELD_TYPE);
            assert (typeElement.isJsonPrimitive());
            String type = typeElement.getAsString();
            return ((YeomanGeneratorControl)GSON.fromJson(json, CONTROLS.get(type))).createUI();
        }
        catch (RuntimeException e) {
            LOGGER.error("Cannot parse text " + json, (Throwable)e);
            throw e;
        }
    }
}

