/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.run.controls;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import java.lang.reflect.Type;
import javax.swing.JComponent;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControlUtil;

public class YeomanGeneratorCheckboxControl
implements YeomanGeneratorControl {
    private String type;
    private String name;
    private String message;
    private Choice[] choices;
    public static final Gson GSON = new Gson();

    @Override
    public YeomanGeneratorControl.YeomanGeneratorControlUI createUI() {
        final FormBuilder builder = FormBuilder.createFormBuilder();
        final JBCheckBox[] checkBoxes = new JBCheckBox[this.choices.length];
        builder.addComponent(YeomanGeneratorControlUtil.buildTitle(StringUtil.isEmpty((String)this.message) ? this.name : this.message));
        for (int i = 0; i < this.choices.length; ++i) {
            Choice choice = this.choices[i];
            JBCheckBox checkBox = new JBCheckBox();
            checkBox.setSelected(choice.checked);
            checkBoxes[i] = checkBox;
            builder.addLabeledComponent((JComponent)checkBox, YeomanGeneratorControlUtil.buildSelectionTitle(StringUtil.isEmpty((String)choice.name) ? choice.value : choice.name));
        }
        return new YeomanGeneratorControl.YeomanGeneratorControlUI(){

            @Override
            public JComponent getComponent() {
                return builder.getPanel();
            }

            @Override
            public String getSelectedValue() {
                StringBuilder builder2 = new StringBuilder();
                for (int i = 0; i < checkBoxes.length; ++i) {
                    JBCheckBox checkBox = checkBoxes[i];
                    if (!checkBox.isSelected()) continue;
                    int length = builder2.length();
                    if (length != 0) {
                        builder2.append(" ");
                    }
                    builder2.append(String.valueOf(i));
                }
                return builder2.toString();
            }
        };
    }

    public static class Adapter
    implements JsonDeserializer<Choice> {
        public Choice deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String value = null;
            String name = null;
            Boolean checked = null;
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                JsonElement valueEl = jsonObject.get("value");
                JsonElement nameEl = jsonObject.get("name");
                JsonElement checkedEl = jsonObject.get("checked");
                if (null != valueEl && !valueEl.isJsonObject() && valueEl.isJsonPrimitive()) {
                    value = valueEl.getAsString();
                }
                if (nameEl != null) {
                    name = nameEl.getAsString();
                }
                if (checkedEl != null && checkedEl.isJsonPrimitive()) {
                    checked = checkedEl.getAsBoolean();
                }
            } else {
                value = json.getAsString();
            }
            Choice choice = new Choice();
            choice.value = value;
            choice.name = name;
            choice.checked = Boolean.TRUE.equals(checked);
            return choice;
        }
    }

    public static class Choice {
        private String value;
        private String name;
        private boolean checked;
    }
}

