/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.ui.run.controls;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import java.lang.reflect.Type;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControl;
import jetbrains.plugins.yeoman.projectGenerator.ui.run.controls.YeomanGeneratorControlUtil;
import org.jetbrains.annotations.Nullable;

public class YeomanGeneratorListControl
implements YeomanGeneratorControl {
    public static final String DIFF_VALUE = "diff";
    public static final Gson GSON = new Gson();
    private String type;
    private String name;
    private String message;
    private Choice[] choices;
    @SerializedName(value="default")
    private Object defaultValueObject = "";

    private int getDefaultValueNumber() {
        if (this.defaultValueObject instanceof Number) {
            return ((Number)this.defaultValueObject).intValue();
        }
        if (this.defaultValueObject instanceof String) {
            for (int i = 0; i < this.choices.length; ++i) {
                Choice choice = this.choices[i];
                if (!this.defaultValueObject.equals(choice.value)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public YeomanGeneratorControl.YeomanGeneratorControlUI createUI() {
        final FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent(YeomanGeneratorControlUtil.buildTitle(StringUtil.isEmpty((String)this.message) ? this.name : this.message));
        ButtonGroup group = new ButtonGroup();
        final JBRadioButton[] buttons = new JBRadioButton[this.choices.length];
        int diffButtonIndex = -1;
        for (int i = 0; i < this.choices.length; ++i) {
            JBRadioButton button;
            Choice choice = this.choices[i];
            buttons[i] = button = new JBRadioButton(YeomanGeneratorControlUtil.wrapText(StringUtil.isEmpty((String)choice.name) ? choice.value : choice.name));
            if (YeomanGeneratorListControl.isDiffChoice(choice)) {
                diffButtonIndex = i;
                continue;
            }
            builder.addComponent((JComponent)button);
            group.add((AbstractButton)button);
        }
        int defaultValue = this.getDefaultValueNumber();
        if (defaultValue != -1 && diffButtonIndex != defaultValue) {
            buttons[defaultValue].setSelected(true);
        } else {
            buttons[0].setSelected(true);
        }
        return new YeomanGeneratorControl.YeomanGeneratorControlUI(){

            @Override
            public JComponent getComponent() {
                return builder.getPanel();
            }

            @Override
            public String getSelectedValue() {
                for (int i = 0; i < buttons.length; ++i) {
                    JBRadioButton button = buttons[i];
                    if (!button.isSelected()) continue;
                    return String.valueOf(i);
                }
                return "";
            }
        };
    }

    private static boolean isDiffChoice(Choice choice) {
        if (!StringUtil.isEmpty((String)choice.value)) {
            return DIFF_VALUE.equals(choice.value);
        }
        return "d".equals(choice.key) && StringUtil.toLowerCase((String)StringUtil.notNullize((String)choice.name)).startsWith("show the differences");
    }

    public static class Adapter
    implements JsonDeserializer<Choice> {
        public Choice deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String value = null;
            String name = null;
            String key = null;
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                JsonElement valueEl = jsonObject.get("value");
                JsonElement nameEl = jsonObject.get("name");
                JsonElement keyEl = jsonObject.get("key");
                if (null != valueEl && !valueEl.isJsonObject() && valueEl.isJsonPrimitive()) {
                    value = valueEl.getAsString();
                }
                if (nameEl != null) {
                    name = nameEl.getAsString();
                }
                if (keyEl != null) {
                    key = keyEl.getAsString();
                }
            } else {
                value = json.getAsString();
            }
            Choice choice = new Choice();
            choice.value = value;
            choice.name = name;
            choice.key = key;
            return choice;
        }
    }

    public static class Choice {
        @Nullable
        private String value;
        @Nullable
        private String key;
        @Nullable
        private String name;
    }
}

