/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.projectGenerator.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YeomanCommandLineUtil {
    public static Runnable createExecuteCommandLineAction(final @Nullable Project project, final @NotNull GeneralCommandLine commandLine, final @NotNull Ref<RuntimeException> exceptionRef, final @Nullable ProgressIndicator currentIndicator) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil", "createExecuteCommandLineAction"));
        }
        if (exceptionRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionRef", "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil", "createExecuteCommandLineAction"));
        }
        return new Runnable(){

            @Override
            public void run() {
                ProcessOutput output;
                block11: {
                    final ProgressIndicator indicator = currentIndicator == null ? ProgressManager.getInstance().getProgressIndicator() : currentIndicator;
                    indicator.setText(commandLine.getCommandLineString());
                    output = new ProcessOutput();
                    try {
                        Alarm alarm;
                        ProcessAdapter listener = new ProcessAdapter(){

                            public void onTextAvailable(ProcessEvent event, Key outputType) {
                                if (event == null) {
                                    return;
                                }
                                String text = event.getText().trim();
                                if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.STDOUT) {
                                    indicator.setText2(text);
                                }
                            }
                        };
                        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
                        Alarm alarm2 = alarm = project == null ? null : new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
                        if (alarm != null) {
                            alarm.addRequest(new Runnable((OSProcessHandler)processHandler, indicator, alarm){
                                final /* synthetic */ OSProcessHandler val$processHandler;
                                final /* synthetic */ ProgressIndicator val$indicator;
                                final /* synthetic */ Alarm val$alarm;
                                {
                                    this.val$processHandler = oSProcessHandler;
                                    this.val$indicator = progressIndicator;
                                    this.val$alarm = alarm;
                                }

                                @Override
                                public void run() {
                                    if (!this.val$processHandler.isProcessTerminated()) {
                                        if (this.val$indicator.isCanceled()) {
                                            this.val$processHandler.destroyProcess();
                                        } else {
                                            this.val$alarm.addRequest((Runnable)this, TimeUnit.SECONDS.toMillis(1L));
                                        }
                                    }
                                }
                            }, TimeUnit.SECONDS.toMillis(1L));
                        }
                        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void onTextAvailable(ProcessEvent event, Key outputType) {
                                if (outputType == ProcessOutputTypes.STDERR) {
                                    output.appendStderr(event.getText());
                                } else if (outputType != ProcessOutputTypes.SYSTEM) {
                                    output.appendStdout(event.getText());
                                }
                            }

                            public void processTerminated(ProcessEvent event) {
                                if (alarm != null) {
                                    Disposer.dispose((Disposable)alarm);
                                }
                            }
                        });
                        processHandler.addProcessListener((ProcessListener)listener);
                        processHandler.startNotify();
                        if (processHandler.waitFor((long)((int)TimeUnit.MINUTES.toMillis(10L)))) {
                            try {
                                output.setExitCode(processHandler.getProcess().exitValue());
                                break block11;
                            }
                            catch (Exception e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        processHandler.destroyProcess();
                        output.setTimeout();
                    }
                    catch (ExecutionException e) {
                        exceptionRef.set((Object)new RuntimeException("Cannot execute " + commandLine.getCommandLineString(), e));
                        return;
                    }
                }
                String errorMessage = null;
                if (output.isTimeout()) {
                    errorMessage = "Time limit exceeded for command:\n" + commandLine.getCommandLineString();
                }
                if (output.getExitCode() != 0) {
                    errorMessage = "Failed command:\n" + commandLine.getCommandLineString() + "\nExit code: " + output.getExitCode();
                }
                if (errorMessage != null) {
                    if (!output.getStdout().isEmpty()) {
                        errorMessage = errorMessage + "\nStandard output:\n" + output.getStdout();
                    }
                    if (!output.getStderr().isEmpty()) {
                        errorMessage = errorMessage + "\nStandard error:\n" + output.getStderr();
                    }
                    exceptionRef.set((Object)new RuntimeException(errorMessage));
                }
            }
        };
    }

    public static GeneralCommandLine createBowerInstallCommandLine(@NotNull Project project, @NotNull File workingDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil", "createBowerInstallCommandLine"));
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil", "createBowerInstallCommandLine"));
        }
        BowerSettings settings = BowerSettingsManager.getInstance((Project)project).getSettings();
        BowerSettings build = settings.createBuilder().setBowerJsonPath(new File(workingDirectory, "bower.json").getAbsolutePath()).build();
        try {
            GeneralCommandLine line = BowerCommandLineUtil.createCommandLine((BowerSettings)build);
            line.addParameter("install");
            return line;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static GeneralCommandLine createNpmInstallCommandLine(@NotNull File workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "jetbrains/plugins/yeoman/projectGenerator/util/YeomanCommandLineUtil", "createNpmInstallCommandLine"));
        }
        YeomanGlobalSettings files = YeomanGlobalSettings.getInstance();
        NodeJsLocalInterpreter interpreter = files.getInterpreter();
        assert (interpreter != null);
        try {
            return NodeCommandLineUtil.createNpmCommandLine((File)workingDirectory, (NodeJsLocalInterpreter)interpreter, (List)ContainerUtil.newArrayList((Object[])new String[]{"install"}));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

