/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jetbrains.plugins.yeoman.YeomanBundle;
import jetbrains.plugins.yeoman.settings.YeomanGlobalSettings;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class YeomanConfigurable
implements Configurable,
Configurable.NoScroll {
    public static final String ID = "settings.javascript.yeoman";
    private final YeomanGlobalSettings myYeomanGlobalSettings = YeomanGlobalSettings.getInstance();
    private NodeJsInterpreterField myNodeTextField;
    private TextFieldWithHistoryWithBrowseButton myYeomanPackageField;

    @Nls
    public String getDisplayName() {
        return YeomanBundle.message("settings.yeoman.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.yeoman";
    }

    @Nullable
    public JComponent createComponent() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        this.myNodeTextField = new NodeJsInterpreterField(project, false);
        this.myYeomanPackageField = SwingHelper.createTextFieldWithHistoryWithBrowseButton(null, (String)YeomanBundle.message("yeoman.configurable.package.dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), null);
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent("&Node interpreter:", (JComponent)this.myNodeTextField);
        builder.addLabeledComponent(YeomanBundle.message("yeoman.configurable.package.dialog.label", new Object[0]), (JComponent)this.myYeomanPackageField);
        JPanel panel = builder.getPanel();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel, "North");
        wrapper.setPreferredSize(new Dimension(400, 200));
        return wrapper;
    }

    public boolean isModified() {
        return !StringUtil.equals((CharSequence)StringUtil.notNullize((String)this.myYeomanGlobalSettings.getNodeRefPath()), (CharSequence)this.getNodeInterpreterValue()) || !StringUtil.equals((CharSequence)StringUtil.notNullize((String)this.myYeomanGlobalSettings.getYoPackagePath()), (CharSequence)StringUtil.notNullize((String)this.myYeomanPackageField.getText()));
    }

    public void apply() throws ConfigurationException {
        this.myYeomanGlobalSettings.setNodePath(this.getNodeInterpreterValue());
        this.myYeomanGlobalSettings.setYoPackage(this.myYeomanPackageField.getText());
    }

    @Nullable
    private String getNodeInterpreterValue() {
        NodeJsInterpreter interpreter = this.myNodeTextField.getInterpreter();
        Project project = ProjectManager.getInstance().getDefaultProject();
        NodeJsInterpreter defaultInterpreter = NodeJsInterpreterManager.getInstance((Project)project).getDefault();
        if (interpreter == null) {
            return null;
        }
        if (defaultInterpreter == null) {
            return interpreter.getReferenceName();
        }
        if (interpreter == defaultInterpreter || StringUtil.equals((CharSequence)interpreter.getReferenceName(), (CharSequence)defaultInterpreter.getReferenceName())) {
            return null;
        }
        return interpreter.getReferenceName();
    }

    public void reset() {
        String interpreter = this.myYeomanGlobalSettings.getNodeRefPath();
        if (interpreter != null) {
            this.myNodeTextField.setInterpreterRef(NodeJsInterpreterRef.create((String)interpreter));
        } else {
            this.myNodeTextField.setInterpreter(NodeJsInterpreterManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).getDefault());
        }
        this.myYeomanPackageField.setTextAndAddToHistory(StringUtil.notNullize((String)this.myYeomanGlobalSettings.getYoPackagePath()));
    }
}

