/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.plugins.yeoman.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import jetbrains.plugins.yeoman.settings.YeomanNodeFiles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="YeomanSettings", storages={@Storage(value="yeomanSettings.xml")})
public class YeomanGlobalSettings
implements YeomanNodeFiles,
PersistentStateComponent<SettingsState> {
    public static final String PACKAGES_URL_KEY = "yeoman.settings.packages.url";
    public static final String PACKAGES_URL_DEFAULT = "https://storage.googleapis.com/generators.yeoman.io/cache.json";
    public static final String RELATIVE_CLI_HELPER_PATH = "runner/yeoman-simple-cli/lib";
    public static final String CLI_HELPER_NAME = "cli.js";
    @NotNull
    private SettingsState myStoreSettings = new SettingsState();

    @Nullable
    public SettingsState getState() {
        return this.myStoreSettings;
    }

    public void loadState(SettingsState state) {
        this.myStoreSettings = state;
    }

    @NotNull
    public static YeomanGlobalSettings getInstance() {
        YeomanGlobalSettings yeomanGlobalSettings = (YeomanGlobalSettings)ServiceManager.getService(YeomanGlobalSettings.class);
        if (yeomanGlobalSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "getInstance"));
        }
        return yeomanGlobalSettings;
    }

    @NotNull
    public String getGeneratorsFileUrl() {
        String string = PropertiesComponent.getInstance().getValue(PACKAGES_URL_KEY, PACKAGES_URL_DEFAULT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "getGeneratorsFileUrl"));
        }
        return string;
    }

    @NotNull
    public String getGeneratorsFileDefaultEncoding() {
        if ("UTF-8" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "getGeneratorsFileDefaultEncoding"));
        }
        return "UTF-8";
    }

    @Nullable
    public String getNodeRefPath() {
        if (!StringUtil.isEmpty((String)this.myStoreSettings.nodeExePath)) {
            return this.myStoreSettings.nodeExePath;
        }
        return null;
    }

    @Override
    @Nullable
    public NodeJsLocalInterpreter getInterpreter() {
        String path = this.getNodeRefPath();
        if (null == path) {
            NodeJsInterpreterManager manager = NodeJsInterpreterManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            return NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)manager.getDefault());
        }
        return NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)NodeJsInterpreterRef.create((String)path).resolve(ProjectManager.getInstance().getDefaultProject()));
    }

    public String getYoPackagePath() {
        if (!StringUtil.isEmpty((String)this.myStoreSettings.yoPackagePath)) {
            return this.myStoreSettings.yoPackagePath;
        }
        return this.getDefaultYoPackagePath();
    }

    public void setNodePath(String path) {
        this.myStoreSettings.nodeExePath = path;
    }

    public void setYoPackage(String path) {
        String normalizedPath = YeomanGlobalSettings.trimAndNotNullize(path);
        this.myStoreSettings.yoPackagePath = !StringUtil.isEmpty((String)normalizedPath) && !StringUtil.equals((CharSequence)normalizedPath, (CharSequence)this.getDefaultYoPackagePath()) ? normalizedPath : null;
    }

    @NotNull
    private static String trimAndNotNullize(String path) {
        String string = StringUtil.notNullize((String)path).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "trimAndNotNullize"));
        }
        return string;
    }

    @Nullable
    private String getDefaultYoPackagePath() {
        String yoPath;
        VirtualFile yo;
        VirtualFile dir;
        NodeJsLocalInterpreter interpreter = this.getInterpreter();
        if (interpreter != null && (dir = interpreter.getGlobalNodeModulesVirtualDir()) != null && (yo = dir.findChild("yo")) != null && yo.exists() && (yoPath = yo.getCanonicalPath()) != null) {
            return FileUtil.toSystemDependentName((String)yoPath);
        }
        return null;
    }

    public String getCLIHelperPath() {
        try {
            String jarPath = PathUtil.getJarPathForClass(YeomanGlobalSettings.class);
            if (!jarPath.endsWith(".jar")) {
                return YeomanGlobalSettings.getCLIHelperPathFromWorkspace();
            }
            return YeomanGlobalSettings.getCLIHelperPathFromJar(jarPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @NotNull
    private static String getCLIHelperPathFromJar(String jarPath) {
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        String string = new File(new File(pluginBaseDir, RELATIVE_CLI_HELPER_PATH), CLI_HELPER_NAME).getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "getCLIHelperPathFromJar"));
        }
        return string;
    }

    @NotNull
    private static String getCLIHelperPathFromWorkspace() throws UnsupportedEncodingException {
        URL resource = YeomanGlobalSettings.class.getClassLoader().getResource(RELATIVE_CLI_HELPER_PATH);
        if (resource == null) {
            throw new RuntimeException("Cannot find file compiler implementation");
        }
        String string = new File(URLDecoder.decode(resource.getPath(), "UTF-8"), CLI_HELPER_NAME).getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/plugins/yeoman/settings/YeomanGlobalSettings", "getCLIHelperPathFromWorkspace"));
        }
        return string;
    }

    public static class SettingsState {
        public String yoPackagePath;
        public String nodeExePath;
    }
}

