/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.codeInsight.NodePathManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleManager {
    private final Project myProject;
    private final NodePathManager myNodePathManager;
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeModuleManager(@NotNull Project project, @NotNull NodeJsCoreLibraryManager coreLibraryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/NodeModuleManager", "<init>"));
        }
        if (coreLibraryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreLibraryManager", "com/jetbrains/nodejs/NodeModuleManager", "<init>"));
        }
        this.myProject = project;
        this.myNodePathManager = new NodePathManager(project);
        this.myCoreLibraryManager = coreLibraryManager;
    }

    @NotNull
    public static NodeModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/NodeModuleManager", "getInstance"));
        }
        NodeModuleManager nodeModuleManager = (NodeModuleManager)ServiceManager.getService((Project)project, NodeModuleManager.class);
        if (nodeModuleManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/NodeModuleManager", "getInstance"));
        }
        return nodeModuleManager;
    }

    private void collectCoreModules(@NotNull VirtualFile requester, @NotNull Map<String, CompletionModuleInfo> modules) {
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/jetbrains/nodejs/NodeModuleManager", "collectCoreModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/jetbrains/nodejs/NodeModuleManager", "collectCoreModules"));
        }
        if (this.myCoreLibraryManager.isAssociatedWithNodeCoreLibrary(requester)) {
            NodeJsCoreLibraryManager coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)this.myProject);
            Collection coreModuleNames = coreLibraryManager.listCoreModuleNames();
            for (String coreModuleName : coreModuleNames) {
                modules.put(coreModuleName, new CompletionModuleInfo(coreModuleName, null, ModuleType.CORE_MODULE));
            }
        }
    }

    @NotNull
    public Collection<CompletionModuleInfo> collectVisibleNodeModules(@Nullable VirtualFile requester) {
        HashMap modules = ContainerUtil.newHashMap();
        if (requester != null) {
            this.collectCoreModules(requester, modules);
        }
        NodeSettings settings = this.getSettings();
        NodeModuleSearchUtil.collectVisibleNodeModules((Map)modules, (Project)this.myProject, (VirtualFile)requester, (NodeSettings)settings);
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/NodeModuleManager", "collectVisibleNodeModules"));
        }
        return collection;
    }

    @Nullable
    private NodeSettings getSettings() {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)this.myProject).getDefault();
        return NodeSettings.create((NodeJsLocalInterpreter)NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter));
    }

    @Nullable
    public ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/jetbrains/nodejs/NodeModuleManager", "resolveModule"));
        }
        NodeJsCoreLibraryManager coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)this.myProject);
        VirtualFile resolvedModuleFile = coreLibraryManager.findCoreModuleFileByName(requiredModuleName);
        if (resolvedModuleFile != null) {
            return new ResolvedModuleInfo(resolvedModuleFile, ModuleType.CORE_MODULE);
        }
        List<VirtualFile> nodePathFolders = this.myNodePathManager.getNodePaths();
        return NodeModuleSearchUtil.resolveModule((String)requiredModuleName, (VirtualFile)requester, (NodeSettings)this.getSettings(), nodePathFolders, (boolean)true, (Project)this.myProject);
    }

    public void dropNodePathCache() {
        this.myNodePathManager.dropCache();
    }
}

