/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionListener;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionView;
import com.jetbrains.nodejs.util.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressProjectPeer
implements WebProjectGenerator.GeneratorPeer<ExpressProjectSettings> {
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final NodeJsInterpreterField myInterpreterField = new NodeJsInterpreterField(ProjectManager.getInstance().getDefaultProject(), false){

        public boolean isDefaultProjectInterpreterField() {
            return true;
        }
    };
    private final NodePackageVersionView myExpressGeneratorVersionView;
    private final ComboBox myTemplateEngine;
    private final ComboBox myStylesheetEngine;
    private final JPanel myContentPanel;
    private final JPanel myOptionsPanel;

    protected ExpressProjectPeer() {
        NodeJsLocalInterpreter interpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
        if (interpreter != null) {
            this.myInterpreterField.setInterpreter((NodeJsInterpreter)interpreter);
        }
        this.myTemplateEngine = UIHelper.createComboboxWithUnavailableDefaultValue();
        this.myStylesheetEngine = UIHelper.createComboboxWithUnavailableDefaultValue();
        this.myExpressGeneratorVersionView = new NodePackageVersionView("express-generator", new MyNodePackageVersionListener(), true);
        this.myInterpreterField.addChangeListener(new NodeJsInterpreterChangeListener(){

            public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                ExpressProjectPeer.this.updateExpressVersion();
            }
        });
        this.updateExpressVersion();
        this.myOptionsPanel = ExpressProjectPeer.createOptionsPanel(this.myExpressGeneratorVersionView, this.myTemplateEngine, this.myStylesheetEngine);
        JPanel pathsPanel = this.createPathsPanel();
        this.myContentPanel = UIHelper.createGrowingDownPanelWithHorizontallyStretchedComponent(SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{pathsPanel, this.myOptionsPanel}));
    }

    private void updateExpressVersion() {
        this.myExpressGeneratorVersionView.setInterpreter(this.myInterpreterField.getInterpreter());
    }

    private void fireStateChanged(boolean validSettings) {
        for (WebProjectGenerator.SettingsStateListener listener : this.myStateListeners) {
            listener.stateChanged(validSettings);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "getComponent"));
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "buildUI"));
        }
        settingsStep.addSettingsField("\u001bNode interpreter:", (JComponent)this.myInterpreterField);
        settingsStep.addSettingsComponent((JComponent)this.myOptionsPanel);
    }

    @NotNull
    public ExpressProjectSettings getSettings() {
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)this.myTemplateEngine.getSelectedItem();
        ExpressStylesheetEngine cssEngine = (ExpressStylesheetEngine)this.myStylesheetEngine.getSelectedItem();
        NodePackageVersion expressGeneratorVersion = this.myExpressGeneratorVersionView.getVersion();
        if (expressGeneratorVersion == null) {
            throw new RuntimeException("express-generator version isn't selected");
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)this.myInterpreterField.getInterpreter());
        if (localInterpreter == null) {
            throw new RuntimeException("Local Node.js interpreter expected");
        }
        ExpressProjectSettings expressProjectSettings = new ExpressProjectSettings(localInterpreter, expressGeneratorVersion, templateEngine, cssEngine);
        if (expressProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "getSettings"));
        }
        return expressProjectSettings;
    }

    public ValidationInfo validate() {
        ValidationInfo info = this.validatePaths();
        if (info != null) {
            return info;
        }
        NodePackageVersion version = this.myExpressGeneratorVersionView.getVersion();
        if (version == null) {
            if (this.myExpressGeneratorVersionView.isLoadingVersions()) {
                return new ValidationInfo("", null);
            }
            return new ValidationInfo("Unspecified express-generator package version", (JComponent)this.myExpressGeneratorVersionView.getComboBox());
        }
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)ObjectUtils.tryCast((Object)this.myTemplateEngine.getSelectedItem(), ExpressTemplateEngine.class);
        if (templateEngine == null) {
            return new ValidationInfo("Template engine is unavailable", (JComponent)this.myTemplateEngine);
        }
        ExpressStylesheetEngine stylesheetEngine = (ExpressStylesheetEngine)ObjectUtils.tryCast((Object)this.myStylesheetEngine.getSelectedItem(), ExpressStylesheetEngine.class);
        if (stylesheetEngine == null) {
            return new ValidationInfo("Stylesheet engine is unavailable", (JComponent)this.myStylesheetEngine);
        }
        return null;
    }

    @Nullable
    private ValidationInfo validatePaths() {
        NodeJsLocalInterpreter localInterpreter;
        try {
            localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)this.myInterpreterField.getInterpreter());
        }
        catch (ExecutionException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myInterpreterField);
        }
        try {
            localInterpreter.getValidNpmCliJsFilePath();
        }
        catch (ExecutionException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myInterpreterField);
        }
        return null;
    }

    public boolean isBackgroundJobRunning() {
        return this.myExpressGeneratorVersionView.isLoadingVersions();
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "addSettingsStateListener"));
        }
        this.myStateListeners.add(listener);
    }

    @NotNull
    private JPanel createPathsPanel() {
        JPanel jPanel = new FormBuilder().addLabeledComponent("&Node interpreter:", (JComponent)this.myInterpreterField).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createPathsPanel"));
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createOptionsPanel(@NotNull NodePackageVersionView expressGeneratorVersionView, @NotNull ComboBox templateEngine, @NotNull ComboBox cssEngine) {
        if (expressGeneratorVersionView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressGeneratorVersionView", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createOptionsPanel"));
        }
        if (templateEngine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateEngine", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createOptionsPanel"));
        }
        if (cssEngine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssEngine", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createOptionsPanel"));
        }
        LabeledComponent<JComponent> versionLabeledComponent = ExpressProjectPeer.createLabeledComponent("&Version:", expressGeneratorVersionView.getComponent());
        LabeledComponent<JComponent> templateLabeledComponent = ExpressProjectPeer.createLabeledComponent("&Template:", (JComponent)templateEngine);
        LabeledComponent<JComponent> cssLabeledComponent = ExpressProjectPeer.createLabeledComponent("&CSS:", (JComponent)cssEngine);
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{versionLabeledComponent, templateLabeledComponent, cssLabeledComponent});
        ExpressProjectPeer.setMaxPreferredWidth(expressGeneratorVersionView.getComboBox(), templateEngine, cssEngine);
        JPanel expressGeneratorPanel = ExpressProjectPeer.createExpressGeneratorPanel(versionLabeledComponent);
        JPanel optionsPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{templateLabeledComponent, Box.createVerticalStrut(4), cssLabeledComponent});
        optionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Options"));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{Box.createVerticalStrut(10), expressGeneratorPanel, Box.createVerticalStrut(4), optionsPanel});
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createOptionsPanel"));
        }
        return jPanel;
    }

    private static void setMaxPreferredWidth(ComboBox ... comboBoxes) {
        int maxWidth = 0;
        for (ComboBox box : comboBoxes) {
            maxWidth = Math.max(maxWidth, box.getPreferredSize().width);
        }
        for (ComboBox box : comboBoxes) {
            SwingHelper.setPreferredWidth((Component)box, (int)maxWidth);
        }
    }

    @NotNull
    private static LabeledComponent<JComponent> createLabeledComponent(@NotNull String text, @NotNull JComponent comp) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createLabeledComponent"));
        }
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createLabeledComponent"));
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(comp);
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)panel, (String)text);
        labeledComponent.setLabelLocation("West");
        LabeledComponent labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createLabeledComponent"));
        }
        return labeledComponent2;
    }

    @NotNull
    private static JPanel createExpressGeneratorPanel(@NotNull LabeledComponent<JComponent> versionLabeledComponent) {
        if (versionLabeledComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionLabeledComponent", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createExpressGeneratorPanel"));
        }
        JEditorPane descriptionPane = SwingHelper.createHtmlViewer((boolean)true, (Font)UIUtil.getTitledBorderFont(), null, null);
        Color color = UIUtil.getLabelForeground();
        SwingHelper.setHtml((JEditorPane)descriptionPane, (String)ExpressProjectPeer.getExpressGeneratorDescriptionHtml(color), (Color)color);
        descriptionPane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        versionLabeledComponent.setBorder(BorderFactory.createEmptyBorder(4, JBUI.scale((int)20), 0, 0));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{descriptionPane, versionLabeledComponent});
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "createExpressGeneratorPanel"));
        }
        return jPanel;
    }

    @NotNull
    private static String getExpressGeneratorDescriptionHtml(@Nullable Color linkColor) {
        StringBuilder builder = new StringBuilder("Application will be created by <a href='https://www.npmjs.com/package/express-generator'");
        if (linkColor != null) {
            builder.append(" style='color:#").append(ColorUtil.toHex((Color)linkColor)).append("'");
        }
        builder.append(">express-generator</a>");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer", "getExpressGeneratorDescriptionHtml"));
        }
        return string;
    }

    private class MyNodePackageVersionListener
    implements NodePackageVersionListener {
        private MyNodePackageVersionListener() {
        }

        @Override
        public void onVersionSelected(@Nullable NodePackageVersion selectedVersion) {
            ArrayList templates = Collections.emptyList();
            ArrayList stylesheets = Collections.emptyList();
            if (selectedVersion != null) {
                templates = ContainerUtil.newArrayList((Object[])new ExpressTemplateEngine[]{ExpressTemplateEngine.JADE, ExpressTemplateEngine.EJS});
                stylesheets = ContainerUtil.newArrayList((Object[])new ExpressStylesheetEngine[]{ExpressStylesheetEngine.PLAIN_CSS, ExpressStylesheetEngine.STYLUS});
                if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("3.0.0")) <= 0) {
                    templates.add(ExpressTemplateEngine.HBS);
                    templates.add(ExpressTemplateEngine.HOGAN);
                    stylesheets.add(ExpressStylesheetEngine.LESS);
                    stylesheets.add(ExpressStylesheetEngine.COMPASS);
                }
                if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("4.13.0")) <= 0) {
                    stylesheets.add(ExpressStylesheetEngine.SASS);
                }
            }
            SwingHelper.updateItems((JComboBox)ExpressProjectPeer.this.myTemplateEngine, templates, null);
            SwingHelper.updateItems((JComboBox)ExpressProjectPeer.this.myStylesheetEngine, stylesheets, null);
            ExpressProjectPeer.this.fireStateChanged(selectedVersion != null);
        }
    }
}

