/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.nodeBoilerplate;

import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GithubTagInfo;
import icons.NodeJSIcons;
import java.io.File;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeBoilerplateGenerator
extends AbstractGithubTagDownloadedProjectGenerator {
    private final NotificationGroup myGroup = new NotificationGroup(this.getName() + " Project Generator", NotificationDisplayType.STICKY_BALLOON, true, null);

    @NotNull
    protected String getDisplayName() {
        if ("Node.js Boilerplate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "getDisplayName"));
        }
        return "Node.js Boilerplate";
    }

    @NotNull
    public String getGithubUserName() {
        if ("robrighter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "getGithubUserName"));
        }
        return "robrighter";
    }

    @NotNull
    public String getGithubRepositoryName() {
        if ("node-boilerplate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "getGithubRepositoryName"));
        }
        return "node-boilerplate";
    }

    @NotNull
    public String getDescription() {
        if ("<html>Template based on HTML5 Boilerplate, Express, Jade and Socket.IO <br>&nbsp;<a href='https://github.com/robrighter/node-boilerplate'>https://github.com/robrighter/node-boilerplate</a></html>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "getDescription"));
        }
        return "<html>Template based on HTML5 Boilerplate, Express, Jade and Socket.IO <br>&nbsp;<a href='https://github.com/robrighter/node-boilerplate'>https://github.com/robrighter/node-boilerplate</a></html>";
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo githubTagInfo, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "generateProject"));
        }
        if (githubTagInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "githubTagInfo", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "generateProject"));
        }
        super.generateProject(project, baseDir, githubTagInfo, module);
        String message = NodeBoilerplateGenerator.formatMessage(baseDir);
        if (message != null) {
            this.notify(project, message);
        }
    }

    @Nullable
    public String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "getPrimaryZipArchiveUrlForDownload"));
        }
        return null;
    }

    private void notify(final @NotNull Project project, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "notify"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "notify"));
        }
        Notification notification = this.myGroup.createNotification(this.getName(), message, NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                VirtualFile virtualFile;
                File file;
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator$1", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (file = new File(event.getDescription())).isFile() && (virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true)) != null) {
                    OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile, 0);
                    fileDescriptor.navigate(true);
                }
            }
        });
        notification.notify(project);
    }

    @Nullable
    private static String formatMessage(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "formatMessage"));
        }
        String initScriptLink = NodeBoilerplateGenerator.toHyperLinkIfExists(baseDir, SystemInfo.isWindows ? "initproject.bat" : "initproject.sh");
        String readmeLink = NodeBoilerplateGenerator.toHyperLinkIfExists(baseDir, "README.md");
        StringBuilder message = new StringBuilder("To finish project configuration please ");
        if (initScriptLink != null) {
            message.append("run ").append(initScriptLink).append(" script manually.");
            if (readmeLink != null) {
                message.append("<br>See ").append(readmeLink).append(" for details.");
            }
        } else if (readmeLink != null) {
            message.append("see ").append(readmeLink).append(".");
        } else {
            return null;
        }
        return message.toString();
    }

    @Nullable
    private static String toHyperLinkIfExists(@NotNull VirtualFile baseDir, @NotNull String resourceName) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "toHyperLinkIfExists"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/jetbrains/nodejs/boilerplate/nodeBoilerplate/NodeBoilerplateGenerator", "toHyperLinkIfExists"));
        }
        File file = new File(baseDir.getPath(), resourceName);
        if (file.isFile()) {
            return "<a href='" + file.getAbsolutePath() + "'>" + resourceName + "</a>";
        }
        return null;
    }

    public Icon getIcon() {
        return NodeJSIcons.Nodejs_16;
    }
}

