/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.nodejs.settings.NodeCoreSourcesView;
import com.jetbrains.nodejs.settings.NodeSettingsConfigurable;
import icons.NodeJSIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnableNodeJsCodeAssistanceFix
implements HighPriorityAction,
LocalQuickFix,
Iconable {
    public Icon getIcon(@Iconable.IconFlags int flags) {
        return NodeJSIcons.Nodejs_16;
    }

    @NotNull
    public String getName() {
        if ("Enable Node.js coding assistance" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "getName"));
        }
        return "Enable Node.js coding assistance";
    }

    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "getFamilyName"));
        }
        return "Node.js";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "applyFix"));
        }
        VirtualFile requestor = EnableNodeJsCodeAssistanceFix.getRequestor(descriptor);
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getDefault();
        if (interpreter == null) {
            EnableNodeJsCodeAssistanceFix.showSettings(project, requestor);
        } else {
            ModalityState modalityState = ModalityState.current();
            interpreter.provideCachedVersionOrFetch(version -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "lambda$applyFix$1"));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "lambda$null$0"));
                    }
                    if (version != null) {
                        NodeCoreSourcesView.enableCodeAssistance(project, interpreter, version, requestor, null);
                    } else {
                        EnableNodeJsCodeAssistanceFix.showSettings(project, requestor);
                    }
                }, modalityState, project.getDisposed());
            });
        }
    }

    @Nullable
    private static VirtualFile getRequestor(@NotNull ProblemDescriptor descriptor) {
        PsiFile psiFile;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "getRequestor"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element != null && element.isValid() && (psiFile = element.getContainingFile()) != null) {
            return psiFile.getVirtualFile();
        }
        return null;
    }

    private static void showSettings(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/codeInsight/EnableNodeJsCodeAssistanceFix", "showSettings"));
        }
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new NodeSettingsConfigurable(project, requestor, true));
    }
}

