/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight.modules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.nodejs.NodeJSBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ImportNodeJsModuleFix
extends ImportCommonJSModuleFix {
    private String myText;

    public ImportNodeJsModuleFix(@NotNull PsiElement node, @NotNull ModuleFixCreator.FixDescriptor descriptor, @NotNull String quoteString) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "<init>"));
        }
        if (quoteString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteString", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "<init>"));
        }
        super(node, descriptor, quoteString);
    }

    protected boolean modifyExistingImports(@NotNull PsiElement scope, Editor editor, @NotNull PsiElement reference) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "modifyExistingImports"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "modifyExistingImports"));
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myText == null) {
            String postfix = this.getPostfix();
            StringBuilder builder = new StringBuilder();
            String wholeImportWrapQuote = "'".equals(this.myQuotes) ? "\"" : "'";
            builder.append("Insert ").append(wholeImportWrapQuote).append("require(").append(this.myQuotes).append(this.getPath()).append(this.myQuotes).append(")").append(postfix).append(wholeImportWrapQuote);
            this.myText = builder.toString();
        }
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = NodeJSBundle.message("node.js.modules.dependencies.missing.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    private String getPostfix() {
        if (this.myFixDescriptor.getTail() == null && !this.myFixDescriptor.isModuleElementIsMissing() && (this.myFixDescriptor.getFirstWordInExportsName() == null || this.myFixDescriptor.getFirstWordInExportsName().equals(this.myFixDescriptor.getFirstWordInFile()))) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "getPostfix"));
            }
            return "";
        }
        String postfix = "";
        if (this.myFixDescriptor.getFirstWordInExportsName() != null) {
            postfix = "." + this.myFixDescriptor.getFirstWordInExportsName();
        }
        if (this.myFixDescriptor.getTail() != null) {
            postfix = postfix + "." + StringUtil.join((String[])this.myFixDescriptor.getTail(), (String)".");
        }
        String string = postfix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "getPostfix"));
        }
        return string;
    }

    protected PsiElement createRequire(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/nodejs/codeInsight/modules/ImportNodeJsModuleFix", "createRequire"));
        }
        StringBuilder text = new StringBuilder();
        String[] tail = this.myFixDescriptor.getTail();
        String varName = tail != null ? tail[tail.length - 1] : this.myFixDescriptor.getFirstWordInFile();
        text.append("var ").append(varName).append(" = require(").append(this.myQuotes).append(this.getPath()).append(this.myQuotes).append(")");
        String postfix = this.getPostfix();
        text.append(postfix).append(JSCodeStyleSettings.getSemicolon((PsiFile)psiFile));
        PsiFile file = ImportNodeJsModuleFix.createDummyFile((Project)psiFile.getProject(), (String)text.toString());
        return file.getFirstChild();
    }

    protected boolean isPreferImportAnchor() {
        return false;
    }
}

