/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight.require;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.nodejs.packages.NodePackageListCachingProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeRemotePackagesCompletionContributor
extends CompletionContributor {
    public static final LookupElementRenderer<LookupElement> RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            presentation.setItemText(element.getLookupString());
            presentation.setTypeGrayed(true);
            presentation.setTypeText("remote module");
        }
    };

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        JSCallExpression call;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/codeInsight/require/NodeRemotePackagesCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/codeInsight/require/NodeRemotePackagesCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getOriginalPosition();
        if (position == null) {
            return;
        }
        String text = StringUtil.unquoteString((String)position.getText());
        if (NodeModuleSearchUtil.isFileModuleRequired((String)text.trim())) {
            return;
        }
        if (position.getParent() instanceof JSLiteralExpression && position.getParent().getParent() instanceof JSArgumentList && position.getParent().getParent().getParent() instanceof JSCallExpression && (call = (JSCallExpression)position.getParent().getParent().getParent()).isRequireCall()) {
            if (parameters.getInvocationCount() > 1 || CompletionType.SMART.equals((Object)parameters.getCompletionType())) {
                if (text.trim().length() < 3) {
                    NodeRemotePackagesCompletionContributor.advertisement(text, result);
                    return;
                }
                List<String> packages = NodePackageListCachingProvider.getInstance().getPackageNames();
                for (String repoPackage : packages) {
                    if (!result.getPrefixMatcher().prefixMatches(repoPackage)) continue;
                    result.consume((LookupElement)NodeRemotePackagesCompletionContributor.createElement(repoPackage));
                }
            } else {
                NodeRemotePackagesCompletionContributor.advertisement(text, result);
            }
        }
    }

    private static void advertisement(String text, CompletionResultSet result) {
        if (text.trim().length() < 3) {
            result.addLookupAdvertisement("Type at least 3 symbols and press " + NodeRemotePackagesCompletionContributor.getActionShortcut((String)"CodeCompletion") + " twice for remote packages");
        } else {
            result.addLookupAdvertisement("Press " + NodeRemotePackagesCompletionContributor.getActionShortcut((String)"CodeCompletion") + " again for remote packages");
        }
    }

    @NotNull
    private static LookupElementBuilder createElement(String repoPackage) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)repoPackage).withRenderer(RENDERER);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/require/NodeRemotePackagesCompletionContributor", "createElement"));
        }
        return lookupElementBuilder;
    }
}

