/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.execution.NodeCommandLineState;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ReadV8LogRawAction;
import com.jetbrains.nodejs.run.profile.heap.TakeHeapSnapshotAction;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeProfilingRuntimeConfigurer {
    private final Logger LOG;
    @NotNull
    private final NodeJsRunConfiguration myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    private final NodeFileTransfer myFileTransfer;
    @Nullable
    private NodeProfilingRuntimeSettings myRuntimeSettings;
    private TakeHeapSnapshotAction mySnapshotAction;
    private final boolean myTakeHeapSnapshots;
    private final boolean myProfileCpu;
    private ProfilingExecutionListener myListener;
    private String myHost;
    private static final String subPath = "profilerWrapper/v8-profiler-app.js";

    public NodeProfilingRuntimeConfigurer(@NotNull NodeJsRunConfiguration configuration, @NotNull ExecutionEnvironment environment, NodeFileTransfer fileTransfer) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "<init>"));
        }
        this.LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.execution.NodeProfilingRuntimeConfigurer");
        this.myConfiguration = configuration;
        this.myEnvironment = environment;
        this.myFileTransfer = fileTransfer;
        this.myTakeHeapSnapshots = NodeProfilingRuntimeConfigurer.proxyForHeapSnapshots(this.myConfiguration);
        this.myProfileCpu = NodeProfilingRuntimeConfigurer.configurationOkForProfiling(this.myConfiguration);
        this.myListener = new ProfilingExecutionListener(this.myConfiguration);
    }

    public static boolean configurationOkForProfiling(NodeJsRunConfiguration configuration) {
        return configuration.getNodeProfilingSettings().isProfile() && configuration.getNodeProfilingSettings().isOpenViewer();
    }

    public static boolean proxyForHeapSnapshots(NodeJsRunConfiguration configuration) {
        return configuration.getNodeProfilingSettings().isAllowRuntimeHeapSnapshot() && !StringUtil.isEmptyOrSpaces((String)configuration.getNodeProfilingSettings().getV8ProfilerPackage()) && !StringUtil.isEmptyOrSpaces((String)configuration.getExePath()) && configuration.getNodeProfilingSettings().getInnerPort() > 0;
    }

    public void setRuntimeSettings(@Nullable NodeProfilingRuntimeSettings runtimeSettings) {
        this.myRuntimeSettings = runtimeSettings;
    }

    @Nullable
    public NodeProfilingRuntimeSettings getRuntimeSettings() {
        return this.myRuntimeSettings;
    }

    public String onCommandLineCreation(String appFilePath, String host) throws ExecutionException {
        String overriddenPath = null;
        Project project = this.myEnvironment.getProject();
        if (this.myTakeHeapSnapshots) {
            overriddenPath = this.proxyAppFile(appFilePath, this.myListener).getPath();
            this.myHost = host;
            this.mySnapshotAction = new TakeHeapSnapshotAction(project, this.myHost, this.myConfiguration.getNodeProfilingSettings().getInnerPort(), this.myConfiguration.getName(), this.myConfiguration.getRawExePath(), this.myConfiguration.getWorkingDirectory(), this.myFileTransfer);
            this.myListener.addAfter((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> this.mySnapshotAction.setDisposed()));
        }
        if (this.myProfileCpu) {
            this.myListener.addAfter((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> {
                if (this.myRuntimeSettings != null) {
                    this.showProfilingResults();
                }
            }));
        }
        if (!this.myListener.isEmpty()) {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
            this.myListener.setConnection(connection);
            connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)this.myListener);
        }
        return overriddenPath;
    }

    public void registerAfterAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "registerAfterAction"));
        }
        this.myListener.addAfter((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "lambda$registerAfterAction$2"));
            }
            runnable.run();
        }));
    }

    public boolean isTakeHeapSnapshots() {
        return this.myTakeHeapSnapshots;
    }

    public boolean isProfileCpu() {
        return this.myProfileCpu;
    }

    public boolean haveProfilingContext() {
        return this.myTakeHeapSnapshots || this.myProfileCpu;
    }

    public TakeHeapSnapshotAction getSnapshotAction() {
        return this.mySnapshotAction;
    }

    private void showProfilingResults() {
        UsageTrigger.trigger((String)"node.js.v8.profiling.show.profiling.after.run");
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myConfiguration.getProject());
        alarm.addRequest(() -> {
            Disposer.dispose((Disposable)alarm);
            List<File> logFiles = null;
            try {
                logFiles = this.myRuntimeSettings.getLogFiles();
            }
            catch (IOException e) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Error with V8 log files: " + e.getMessage(), MessageType.ERROR).notify(this.myConfiguration.getProject());
                return;
            }
            if (logFiles.isEmpty()) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("No V8 log files found.", MessageType.ERROR).notify(this.myConfiguration.getProject());
                return;
            }
            logFiles = this.copyFilesToLogFolder(logFiles);
            for (File file : logFiles) {
                UIUtil.invokeLaterIfNeeded(() -> ReadV8LogRawAction.openFile(this.myConfiguration.getProject(), file));
            }
        }, 500);
    }

    private List<File> copyFilesToLogFolder(List<File> logFiles) {
        File logFolder = this.myRuntimeSettings.getLogFolder();
        if (FileUtil.filesEqual((File)logFiles.get(0).getParentFile(), (File)logFolder)) {
            return logFiles;
        }
        ArrayList<File> result = new ArrayList<File>(logFiles.size());
        if (!logFolder.exists()) {
            FileUtilRt.createDirectory((File)logFolder);
        }
        for (File file : logFiles) {
            LogCopier logCopier = new LogCopier(this.myConfiguration.getProject(), file, logFolder);
            if (!logCopier.copy()) continue;
            result.add(logCopier.getToFile());
        }
        return result;
    }

    private File proxyAppFile(@NotNull String appFilePath, @NotNull ProfilingExecutionListener profilingExecutionListener) throws ExecutionException {
        if (appFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appFilePath", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "proxyAppFile"));
        }
        if (profilingExecutionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilingExecutionListener", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "proxyAppFile"));
        }
        try {
            File proxy = FileUtil.createTempFile((String)"v8profilerProxy", (String)".js");
            String v8pathPattern = "{v8-path}";
            String appPathPattern = "{app-path}";
            String portPattern = "{port}";
            String text = NodeProfilingRuntimeConfigurer.getTemplateText();
            String v8ProfilerPackage = FileUtil.toSystemIndependentName((String)this.myConfiguration.getNodeProfilingSettings().getV8ProfilerPackage().trim());
            text = text.replace("{v8-path}", v8ProfilerPackage);
            text = text.replace("{app-path}", FileUtil.toSystemIndependentName((String)appFilePath));
            text = text.replace("{port}", String.valueOf(this.myConfiguration.getNodeProfilingSettings().getInnerPort()));
            FileUtil.writeToFile((File)proxy, (byte[])text.getBytes(CharsetToolkit.UTF8_CHARSET));
            profilingExecutionListener.addAfter((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> {
                Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)configuration.getProject());
                alarm.addRequest(() -> {
                    FileUtil.delete((File)proxy);
                    Disposer.dispose((Disposable)alarm);
                }, 1000);
            }));
            profilingExecutionListener.addBefore((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    TakeHeapSnapshotAction.sendCommand(this.myHost, configuration.getNodeProfilingSettings().getInnerPort(), "stop");
                }
                catch (IOException e) {
                    this.LOG.info((Throwable)e);
                }
            })));
            return proxy;
        }
        catch (IOException e) {
            throw new ExecutionException("Wasn't able to create proxy file for heap snapshots on the fly taking: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String getTemplateText() throws IOException {
        String jarPath = PathUtil.getJarPathForClass(NodeCommandLineState.class);
        File jarFile = new File(jarPath);
        if (!jarPath.endsWith(".jar")) {
            File file = new File(jarPath, subPath);
            String string = FileUtil.loadFile((File)file, (String)"UTF-8");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "getTemplateText"));
            }
            return string;
        }
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        InputStream stream = null;
        JarFile jFile = new JarFile(jarFile);
        ZipEntry entry = jFile.getEntry(subPath);
        if (entry == null) {
            throw new RuntimeException("Can not find template file to create proxy for runtime V8 heap snapshots taking: " + jarPath + "!/" + subPath);
        }
        stream = jFile.getInputStream(entry);
        String string = new String(FileUtil.loadBytes((InputStream)stream), "UTF-8");
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer", "getTemplateText"));
        }
        return string2;
        finally {
            if (stream != null) {
                stream.close();
            }
            jFile.close();
        }
    }

    private static class ProfilingExecutionListener
    implements ExecutionListener {
        private final List<Consumer<NodeJsRunConfiguration>> myAfterTerminationActions;
        private final List<Consumer<NodeJsRunConfiguration>> myBeforeTerminationActions;
        private final NodeJsRunConfiguration myConfiguration;
        private boolean myWasStartedOk;
        private MessageBusConnection myConnection;

        public ProfilingExecutionListener(NodeJsRunConfiguration configuration) {
            this.myConfiguration = configuration;
            this.myAfterTerminationActions = new ArrayList<Consumer<NodeJsRunConfiguration>>();
            this.myBeforeTerminationActions = new ArrayList<Consumer<NodeJsRunConfiguration>>();
            this.myWasStartedOk = false;
        }

        public void addBefore(Consumer<NodeJsRunConfiguration> consumer) {
            this.myBeforeTerminationActions.add(consumer);
        }

        public void addAfter(Consumer<NodeJsRunConfiguration> consumer) {
            this.myAfterTerminationActions.add(consumer);
        }

        public boolean isEmpty() {
            return this.myBeforeTerminationActions.isEmpty() && this.myAfterTerminationActions.isEmpty();
        }

        public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            if (executorId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processStarted"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processStarted"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processStarted"));
            }
            this.myWasStartedOk = true;
        }

        public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            if (executorId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminating"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminating"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminating"));
            }
            RunProfile runProfile = env.getRunProfile();
            if (this.myConfiguration != runProfile) {
                return;
            }
            if (!this.myWasStartedOk) {
                return;
            }
            if (!(runProfile instanceof NodeJsRunConfiguration)) {
                return;
            }
            for (Consumer<NodeJsRunConfiguration> action : this.myBeforeTerminationActions) {
                action.consume((Object)((NodeJsRunConfiguration)runProfile));
            }
        }

        public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
            if (executorId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminated"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminated"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener", "processTerminated"));
            }
            RunProfile runProfile = env.getRunProfile();
            if (this.myConfiguration != runProfile) {
                return;
            }
            this.myConnection.disconnect();
            if (!this.myWasStartedOk) {
                return;
            }
            if (!(runProfile instanceof NodeJsRunConfiguration)) {
                return;
            }
            for (Consumer<NodeJsRunConfiguration> action : this.myAfterTerminationActions) {
                action.consume((Object)((NodeJsRunConfiguration)runProfile));
            }
        }

        public void setConnection(MessageBusConnection connection) {
            this.myConnection = connection;
        }
    }

    private static class LogCopier {
        private static final long TIMEOUT = 300L;
        private static final int NUM_ATTEMPTS = 10;
        private final Project myProject;
        private final File myFile;
        private final File myLogFolder;
        private IOException myIoException;
        private File myToFile;

        public LogCopier(Project project, File file, File logFolder) {
            this.myProject = project;
            this.myFile = file;
            this.myLogFolder = logFolder;
        }

        public boolean copy() {
            String fileName = this.myFile.getName();
            this.myToFile = new File(this.myLogFolder, fileName);
            if (this.myToFile.exists()) {
                try {
                    this.myToFile = this.createNewToFile(fileName);
                }
                catch (IOException e) {
                    this.notifyException(e);
                    return false;
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.myIoException = null;
                try {
                    FileUtil.copy((File)this.myFile, (File)this.myToFile);
                    FileUtil.delete((File)this.myFile);
                    return true;
                }
                catch (IOException e) {
                    this.myIoException = e;
                    LogCopier.sleep();
                    continue;
                }
            }
            this.notifyException(this.myIoException);
            FileUtil.delete((File)this.myToFile);
            return false;
        }

        public File getToFile() {
            return this.myToFile;
        }

        private static void sleep() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
        }

        private void notifyException(IOException e) {
            NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Can not copy file to log folder: " + e.getMessage(), MessageType.ERROR).notify(this.myProject);
        }

        @NotNull
        private File createNewToFile(String fileName) throws IOException {
            String suffix;
            String prefix;
            int dotIdx = fileName.lastIndexOf(46);
            if (dotIdx == -1) {
                prefix = fileName;
                suffix = "";
            } else {
                prefix = fileName.substring(0, dotIdx);
                suffix = fileName.substring(dotIdx + 1);
            }
            File toFile = FileUtil.createTempFile((File)this.myLogFolder, (String)prefix, (String)suffix, (boolean)true, (boolean)false);
            FileUtil.delete((File)toFile);
            File file = toFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$LogCopier", "createNewToFile"));
            }
            return file;
        }
    }
}

