/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.nodejs.library.NodeJsCoreSourcesFetchSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreLibraryConfigurator {
    static final Logger LOG = Logger.getInstance(NodeJsCoreLibraryConfigurator.class);
    private static final String NODE_CORE_LIBRARY_CONFIGURED_VERSION = "javascript.nodejs.core.library.configured.version";
    private final Project myProject;
    private volatile List<VirtualFile> myTestCoreModuleFiles;

    public NodeJsCoreLibraryConfigurator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public static NodeJsCoreLibraryConfigurator getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "getInstance"));
        }
        NodeJsCoreLibraryConfigurator nodeJsCoreLibraryConfigurator = (NodeJsCoreLibraryConfigurator)ServiceManager.getService((Project)project, NodeJsCoreLibraryConfigurator.class);
        if (nodeJsCoreLibraryConfigurator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "getInstance"));
        }
        return nodeJsCoreLibraryConfigurator;
    }

    @Nullable
    public SemVer getConfiguredCoreLibraryVersion() {
        String value = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        return SemVer.parseFromText((String)value);
    }

    @NotNull
    private String getConfiguredCoreLibraryVersionStr() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
        String string = StringUtil.notNullize((String)value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "getConfiguredCoreLibraryVersionStr"));
        }
        return string;
    }

    private void setCoreLibraryConfigured(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "setCoreLibraryConfigured"));
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION, version, null);
    }

    private void configure(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configure"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configure"));
        }
        if (rootsToAssociateWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configure"));
        }
        try {
            LOG.info("configure(" + interpreter.getReferenceName() + ", " + version + ")");
            String versionStr = version.getRawVersion();
            File coreModulesSrcDir = NodeJsCoreLibraryConfigurator.getCoreModulesSrcDir(versionStr);
            FileUtil.delete((File)coreModulesSrcDir);
            FileUtil.createDirectory((File)coreModulesSrcDir);
            NodeJsCoreSourcesFetchSession session = new NodeJsCoreSourcesFetchSession(this.myProject, interpreter, coreModulesSrcDir);
            session.fetchSourcesSync();
            this.setCoreLibraryConfigured(versionStr);
            NodeJsCoreLibraryConfigurator.refreshIfNeeded(coreModulesSrcDir, () -> {
                if (rootsToAssociateWith == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$configure$0"));
                }
                this.scheduleLibrariesUpdate(true, rootsToAssociateWith, onDone);
            });
        }
        catch (ExecutionException | IOException e) {
            LOG.warn("Cannot configure Node.js Core library", e);
            this.scheduleLibrariesUpdate(false, rootsToAssociateWith, onDone);
        }
    }

    private static void refreshIfNeeded(@NotNull File coreModulesSrcDir, @NotNull Runnable finishRunnable) {
        if (coreModulesSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "refreshIfNeeded"));
        }
        if (finishRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishRunnable", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "refreshIfNeeded"));
        }
        boolean refreshNeeded = NodeJsCoreLibraryConfigurator.isRefreshNeeded(coreModulesSrcDir);
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            if (coreModulesSrcDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$refreshIfNeeded$2"));
            }
            if (finishRunnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishRunnable", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$refreshIfNeeded$2"));
            }
            WriteAction.run(() -> {
                if (coreModulesSrcDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$null$1"));
                }
                if (finishRunnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishRunnable", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$null$1"));
                }
                if (refreshNeeded) {
                    VirtualFile coreModulesDirVirtualDir = VfsUtil.findFileByIoFile((File)coreModulesSrcDir, (boolean)true);
                    if (coreModulesDirVirtualDir == null) {
                        LOG.warn("Cannot find virtual file for " + coreModulesSrcDir.getAbsolutePath() + ", refresh skipped");
                    } else {
                        LOG.info("Refreshing " + coreModulesDirVirtualDir.getPath());
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{coreModulesDirVirtualDir});
                    }
                }
                finishRunnable.run();
            });
        });
    }

    private static boolean isRefreshNeeded(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "isRefreshNeeded"));
        }
        List<File> ioFiles = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir.listFiles());
        for (File ioFile : ioFiles) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file != null && file.isValid()) continue;
            return true;
        }
        return false;
    }

    private void scheduleLibrariesUpdate(boolean success, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (rootsToAssociateWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "scheduleLibrariesUpdate"));
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            if (rootsToAssociateWith == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "lambda$scheduleLibrariesUpdate$4"));
            }
            WriteAction.run(() -> {
                boolean changed = NodeJsCoreLibraryUtil.removeOldLibraries((Project)this.myProject);
                if (success || changed) {
                    JSLibraryManager.getInstance((Project)this.myProject).commitChanges();
                }
            });
            if (success) {
                this.associateWith(rootsToAssociateWith);
            }
            if (onDone != null) {
                ApplicationManager.getApplication().invokeLater(onDone, ModalityState.any(), Condition.FALSE);
            }
        });
    }

    private void associateWith(@NotNull List<VirtualFile> rootsToAssociateWith) {
        if (rootsToAssociateWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "associateWith"));
        }
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance((Project)this.myProject);
        for (VirtualFile root : rootsToAssociateWith) {
            libraryMappings.associate(root, "Node.js Core", true);
            LOG.info("Library 'Node.js Core' have been associated with " + (root == null ? "project" : root.getPath()));
        }
    }

    @NotNull
    private static File getCoreModulesSrcDir(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionStr", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "getCoreModulesSrcDir"));
        }
        File file = new File(JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "nodejs" + File.separatorChar + versionStr + File.separatorChar + "core-modules");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "getCoreModulesSrcDir"));
        }
        return file;
    }

    @NotNull
    private static ScriptingLibraryModel createLibraryModel(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "createLibraryModel"));
        }
        List<VirtualFile> allCoreModulesFiles = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir);
        List compactFiles = ContainerUtil.filter(allCoreModulesFiles, file -> NodeJsCoreModulesCatalog.INSTANCE.isPublicExcludedCoreModule(file.getNameWithoutExtension()));
        ArrayList sourceFiles = ContainerUtil.newArrayList(allCoreModulesFiles);
        sourceFiles.removeAll(compactFiles);
        sourceFiles.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
        NodeCoreLibraryModel nodeCoreLibraryModel = new NodeCoreLibraryModel(sourceFiles, compactFiles);
        if (nodeCoreLibraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "createLibraryModel"));
        }
        return nodeCoreLibraryModel;
    }

    @NotNull
    private static List<VirtualFile> listAllCoreModulesFiles(@NotNull File coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModulesSrcDir", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "listAllCoreModulesFiles"));
        }
        if (coreModulesSrcDir.isDirectory()) {
            List<File> files = NodeJsCoreLibraryConfigurator.listAllCoreModulesFiles(coreModulesSrcDir.listFiles());
            List<VirtualFile> list = NodeJsCoreLibraryConfigurator.toVirtualFiles(files);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "listAllCoreModulesFiles"));
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "listAllCoreModulesFiles"));
        }
        return list;
    }

    @NotNull
    private static List<File> listAllCoreModulesFiles(@Nullable File[] allFiles) {
        if (allFiles == null || allFiles.length == 0) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "listAllCoreModulesFiles"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)allFiles.length);
        for (File file : allFiles) {
            String name;
            if (!file.isFile() || !NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(name = FileUtil.getNameWithoutExtension((String)file.getName())) && !NodeJsCoreModulesCatalog.INSTANCE.isPrivateIncludedCoreModule(name)) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "listAllCoreModulesFiles"));
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> toVirtualFiles(@NotNull List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "toVirtualFiles"));
        }
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)files.size());
        for (File file : files) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (virtualFile == null || !virtualFile.isValid()) {
                LOG.warn("Cannot find virtual file by " + file.getAbsolutePath());
                continue;
            }
            result.add(virtualFile);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "toVirtualFiles"));
        }
        return arrayList;
    }

    public void setCoreModulesForTests(VirtualFile ... testCoreModuleFiles) {
        if (testCoreModuleFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCoreModuleFiles", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "setCoreModulesForTests"));
        }
        this.myTestCoreModuleFiles = Arrays.asList(testCoreModuleFiles);
        JSLibraryManager.getInstance((Project)this.myProject).commitChanges();
    }

    public void removeAllCoreModulesForTests() {
        this.myTestCoreModuleFiles = null;
        JSLibraryManager.getInstance((Project)this.myProject).commitChanges();
    }

    public void configureAndAssociateWithProject(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable Runnable onDone) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configureAndAssociateWithProject"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configureAndAssociateWithProject"));
        }
        this.configureAndAssociateWith(interpreter, version, Collections.singletonList(null), onDone);
    }

    public void configureAndAssociateWith(final @NotNull NodeJsInterpreter interpreter, final @NotNull SemVer version, final @NotNull List<VirtualFile> rootsToAssociateWith, final @Nullable Runnable onDone) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configureAndAssociateWith"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configureAndAssociateWith"));
        }
        if (rootsToAssociateWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator", "configureAndAssociateWith"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.info("configureAndAssociateWith(" + interpreter.getReferenceName() + ", " + version + ")");
        new Task.Modal(this.myProject, "Configuring Node.js Support...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$1", "run"));
                }
                indicator.setIndeterminate(true);
                NodeJsCoreLibraryConfigurator.this.configure(interpreter, version, rootsToAssociateWith, onDone);
            }
        }.setCancelText("Cancel").queue();
    }

    public void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String version = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isNotEmpty((String)version)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PropertiesComponent.getInstance((Project)this.myProject).unsetValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
                JSLibraryManager.getInstance((Project)this.myProject).commitChanges();
            });
        }
    }

    private static class NodeCoreLibraryModel
    extends ScriptingLibraryModel {
        public NodeCoreLibraryModel(@NotNull List<VirtualFile> sourceFiles, @NotNull List<VirtualFile> compactFiles) {
            if (sourceFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeCoreLibraryModel", "<init>"));
            }
            if (compactFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactFiles", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeCoreLibraryModel", "<init>"));
            }
            super("Node.js Core", VfsUtilCore.toVirtualFileArray(sourceFiles), VfsUtilCore.toVirtualFileArray(compactFiles), ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PREDEFINED, false);
        }

        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeCoreLibraryModel", "collectFilesWithGlobalDefinitions"));
            }
            result.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
        }
    }

    public static class NodeJsCorePredefinedLibraryProvider
    extends JSPredefinedLibraryProvider {
        @NotNull
        public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider", "getPredefinedLibraries"));
            }
            NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                List coreModuleFiles = configurator.myTestCoreModuleFiles;
                if (coreModuleFiles == null) {
                    NodeJsCoreLibraryManager.getInstance((Project)project).setScriptingLibraryModel(null);
                    if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider", "getPredefinedLibraries"));
                    }
                    return ScriptingLibraryModel.EMPTY_ARRAY;
                }
                ArrayList result = ContainerUtil.newArrayList((Iterable)coreModuleFiles);
                result.addAll(NodeJsCoreLibraryUtil.getNodeGlobalStubFiles());
                NodeCoreLibraryModel libraryModel = new NodeCoreLibraryModel(result, Collections.emptyList());
                NodeJsCoreLibraryManager.getInstance((Project)project).setScriptingLibraryModel((ScriptingLibraryModel)libraryModel);
                ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
                if (scriptingLibraryModelArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider", "getPredefinedLibraries"));
                }
                return scriptingLibraryModelArray;
            }
            String version = configurator.getConfiguredCoreLibraryVersionStr();
            if (StringUtil.isEmptyOrSpaces((String)version)) {
                NodeJsCoreLibraryManager.getInstance((Project)project).setScriptingLibraryModel(null);
                if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider", "getPredefinedLibraries"));
                }
                return ScriptingLibraryModel.EMPTY_ARRAY;
            }
            File coreModulesSrcDir = NodeJsCoreLibraryConfigurator.getCoreModulesSrcDir(version);
            ScriptingLibraryModel libraryModel = NodeJsCoreLibraryConfigurator.createLibraryModel(coreModulesSrcDir);
            NodeJsCoreLibraryManager.getInstance((Project)project).setScriptingLibraryModel(libraryModel);
            ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
            if (scriptingLibraryModelArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreLibraryConfigurator$NodeJsCorePredefinedLibraryProvider", "getPredefinedLibraries"));
            }
            return scriptingLibraryModelArray;
        }
    }
}

