/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodejs.execution.NodeRemoteContext;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.wip.WipVm;

public class NodeJsCoreSourcesFetchSession {
    private static final Logger LOG = NodeJsCoreLibraryConfigurator.LOG;
    private static final String CONTENT_SUFFIX = "});";
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final File myOutputDir;
    private final NodeRemoteContext myRemoteContext;
    private File myWorkingDirectory;
    private String myRemoteFile;

    public NodeJsCoreSourcesFetchSession(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull File outputDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myOutputDir = outputDir;
        this.myRemoteContext = NodeJsCoreSourcesFetchSession.createRemoteContext(project, interpreter);
    }

    @Nullable
    private static NodeRemoteContext createRemoteContext(@NotNull Project project, @NotNull NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createRemoteContext"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createRemoteContext"));
        }
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (remoteInterpreter == null) {
            return null;
        }
        try {
            return NodeRemoteContext.createContext(project, remoteInterpreter.getRemoteUrl(), null, NodeRemoteContext.NoPluginReaction.message);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSourcesSync() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler;
        long startNanoTime = System.nanoTime();
        int debugPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        LOG.info("Running " + commandLine.getCommandLineString());
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)this.myInterpreter);
        if (remoteInterpreter != null) {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
            }
            try {
                processHandler = manager.createProcessHandler(this.myProject, commandLine, remoteInterpreter.getRemoteUrl(), debugPort, -1);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        } else {
            processHandler = new KillableColoredProcessHandler(commandLine);
        }
        try {
            MyProcessListener listener = new MyProcessListener();
            processHandler.addProcessListener((ProcessListener)listener);
            processHandler.startNotify();
            listener.awaitReady();
            this.attachDebuggerSync(debugPort, NodeCommandLineUtil.shouldUseInspectorProtocol((GeneralCommandLine)commandLine));
        }
        finally {
            NodeJsCoreSourcesFetchSession.terminateSync((OSProcessHandler)processHandler);
        }
        if (this.myRemoteContext != null) {
            this.myRemoteContext.getManager().getFileTransfer(this.myProject, this.myRemoteContext.getRemoteSdkAdditionalData()).deleteRemote(this.myRemoteFile);
        } else {
            FileUtil.delete((File)this.myWorkingDirectory);
        }
        LOG.info("Done in " + TimeoutUtil.getDurationMillis((long)startNanoTime) + " ms, located in " + this.myOutputDir.getAbsolutePath());
    }

    private static void terminateSync(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "terminateSync"));
        }
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null);
    }

    private void attachDebuggerSync(int debugPort, boolean useInspectorProtocol) throws IOException, ExecutionException {
        List scripts;
        Vm vm;
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), debugPort);
        RemoteVmConnection connection = useInspectorProtocol ? new WipRemoteVmConnection() : NodeDebugProgramRunnerKt.createRemoteConnection();
        Promise vmPromise = connection.open(address);
        try {
            vm = (Vm)Objects.requireNonNull(vmPromise.blockingGet(30, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot connect to VM", (Throwable)e);
        }
        try {
            Promise<List<Pair<String, String>>> promise = NodeJsCoreSourcesFetchSession.fetchScripts(vm);
            scripts = (List)Objects.requireNonNull(promise.blockingGet(120, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to fetch node core modules", (Throwable)e);
        }
        for (Pair script : scripts) {
            String filename = (String)script.getFirst();
            if (!NodeJsCoreSourcesFetchSession.shouldSaveScript(filename)) continue;
            File outFile = new File(this.myOutputDir, (String)script.first);
            String content = NodeJsCoreSourcesFetchSession.refine((String)script.second);
            FileUtil.writeToFile((File)outFile, (String)content);
        }
    }

    @NotNull
    private static Promise<List<Pair<String, String>>> fetchScripts(@NotNull Vm vm) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "fetchScripts"));
        }
        if (vm instanceof WipVm) {
            ((WipVm)vm).enableDebugger();
        }
        AsyncPromise promise = new AsyncPromise();
        NodeJsCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, System.currentTimeMillis(), 0, () -> {
            if (vm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "lambda$fetchScripts$2"));
            }
            List<Script> scripts = NodeJsCoreSourcesFetchSession.listLoadedScripts(vm);
            CopyOnWriteArrayList data = new CopyOnWriteArrayList();
            CountDownLatch contentsLatch = new CountDownLatch(scripts.size());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (vm == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "lambda$null$1"));
                }
                for (Script script : scripts) {
                    vm.getScriptManager().getSource(script).processed(content -> {
                        if (content == null) {
                            LOG.info("Cannot load content for " + script);
                        } else {
                            data.add(Pair.create((Object)script.getUrl().getPath(), (Object)content));
                        }
                        contentsLatch.countDown();
                    });
                }
            });
            try {
                contentsLatch.await(110L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
            LOG.info("Loaded " + data.size() + " scripts with content");
            promise.setResult(data);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "fetchScripts"));
        }
        return asyncPromise;
    }

    /*
     * WARNING - void declaration
     */
    private static void doWhenScriptLoadingSettlesDown(@NotNull Vm vm, long startTimeMillis, int prevLoadedScriptCount, @NotNull Runnable runnable) {
        void onReady;
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "doWhenScriptLoadingSettlesDown"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onReady", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "doWhenScriptLoadingSettlesDown"));
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> NodeJsCoreSourcesFetchSession.lambda$doWhenScriptLoadingSettlesDown$3(vm, prevLoadedScriptCount, (Runnable)onReady, startTimeMillis), prevLoadedScriptCount == 0 ? 100L : 500L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static List<Script> listLoadedScripts(@NotNull Vm vm) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "listLoadedScripts"));
        }
        ArrayList<Script> scripts = new ArrayList<Script>();
        vm.getScriptManager().forEachScript(script -> {
            scripts.add((Script)script);
            return true;
        });
        ArrayList<Script> arrayList = scripts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "listLoadedScripts"));
        }
        return arrayList;
    }

    private static boolean shouldSaveScript(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "shouldSaveScript"));
        }
        if (StringUtil.containsChar((String)filename, (char)'/') || StringUtil.containsChar((String)filename, (char)'\\')) {
            return false;
        }
        String moduleName = FileUtil.getNameWithoutExtension((String)filename);
        if (NodeJsCoreModulesCatalog.INSTANCE.isIncludedCoreModule(moduleName)) {
            return true;
        }
        return !filename.startsWith("_");
    }

    private static String refine(@NotNull String source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "refine"));
        }
        String prefix = NodeJsCoreSourcesFetchSession.findPrefixToRemove(source = source.trim());
        if (prefix != null && source.endsWith(CONTENT_SUFFIX)) {
            return source.substring(prefix.length(), source.length() - CONTENT_SUFFIX.length());
        }
        return source;
    }

    @Nullable
    private static String findPrefixToRemove(@NotNull String source) {
        char ch;
        int lastPrefixCharInd;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "findPrefixToRemove"));
        }
        String start = "(function (";
        if (!source.startsWith(start)) {
            return null;
        }
        int paramsStartInd = start.length();
        int paramsEndInd = source.indexOf(")", paramsStartInd);
        if (paramsEndInd == -1) {
            return null;
        }
        String params = source.substring(paramsStartInd, paramsEndInd);
        if (!params.contains("require")) {
            return null;
        }
        int openBraceInd = source.indexOf(123, paramsEndInd + 1);
        if (openBraceInd == -1) {
            return null;
        }
        if (!source.substring(paramsEndInd + 1, openBraceInd).trim().isEmpty()) {
            return null;
        }
        for (lastPrefixCharInd = openBraceInd + 1; lastPrefixCharInd < source.length() && (ch = source.charAt(lastPrefixCharInd)) != '\n'; ++lastPrefixCharInd) {
            if (Character.isWhitespace(ch)) continue;
            --lastPrefixCharInd;
            break;
        }
        if (lastPrefixCharInd >= source.length()) {
            return null;
        }
        return source.substring(0, lastPrefixCharInd + 1);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws IOException, ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.myRemoteContext == null) {
            this.myWorkingDirectory = NodeJsCoreSourcesFetchSession.createWorkingDirectory();
            commandLine.setWorkDirectory(this.myWorkingDirectory.getAbsolutePath());
        } else {
            commandLine.setWorkDirectory(this.myRemoteContext.getRemoteWorkingDirectory());
        }
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        String exePath = this.myRemoteContext != null ? this.myRemoteContext.getRemoteInterpreterPath() : NodeJsLocalInterpreter.cast((NodeJsInterpreter)this.myInterpreter).getInterpreterSystemDependentPath();
        commandLine.setExePath(exePath);
        commandLine.setRedirectErrorStream(true);
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)false, (NodeJsInterpreter)this.myInterpreter, (boolean)true);
        File script = NodeJsCodeLocator.getFileRelativeToJsDir("node-core-modules/node-core-modules-loader.js");
        if (this.myRemoteContext != null) {
            NodeFileTransfer transfer = this.myRemoteContext.getManager().getFileTransfer(this.myProject, this.myRemoteContext.getRemoteSdkAdditionalData());
            this.myRemoteFile = transfer.copyToRemoteTmpFile(this.myRemoteContext.getRemoteWorkingDirectory(), "node-core-modules-loader.js", FileUtil.loadFile((File)script));
            commandLine.addParameter(this.myRemoteFile);
        } else {
            commandLine.addParameter(script.getAbsolutePath());
        }
        commandLine.addParameters((List)NodeJsCoreModulesCatalog.INSTANCE.getPublicCoreModules());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static File createWorkingDirectory() throws IOException {
        File file = FileUtil.createTempDirectory((String)"intellij-node-core-modules-", null, (boolean)true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createWorkingDirectory"));
        }
        return file;
    }

    private static /* synthetic */ void lambda$doWhenScriptLoadingSettlesDown$3(@NotNull Vm vm, int prevLoadedScriptCount, @NotNull Runnable onReady, long startTimeMillis) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "lambda$doWhenScriptLoadingSettlesDown$3"));
        }
        if (onReady == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onReady", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "lambda$doWhenScriptLoadingSettlesDown$3"));
        }
        List<Script> scripts = NodeJsCoreSourcesFetchSession.listLoadedScripts(vm);
        int loadedScriptCount = scripts.size();
        LOG.info("Loaded " + loadedScriptCount + " scripts, previously " + prevLoadedScriptCount);
        if (loadedScriptCount > 0) {
            if (loadedScriptCount == prevLoadedScriptCount) {
                onReady.run();
                return;
            }
            if (System.currentTimeMillis() - startTimeMillis > TimeUnit.SECONDS.toMillis(10L)) {
                LOG.info("Stop waiting for new loaded scripts");
                onReady.run();
                return;
            }
        }
        NodeJsCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, startTimeMillis, loadedScriptCount, onReady);
    }

    private static class MyProcessListener
    extends ProcessAdapter {
        private static final String READY_MESSAGE = "@debugger: core modules loaded, ready for communication";
        private final StringBuffer myStdOutBuffer = new StringBuffer();
        private final CountDownLatch myReadyLatch = new CountDownLatch(1);

        private MyProcessListener() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text = StringUtil.notNullize((String)event.getText());
            if (text.isEmpty() || outputType == ProcessOutputTypes.SYSTEM) {
                return;
            }
            String logPrefix = outputType == ProcessOutputTypes.STDERR ? "[stderr] " : "[stdout] ";
            LOG.info(logPrefix + StringUtil.trimEnd((String)text, (String)"\n"));
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myStdOutBuffer.append(text);
                if (this.isReady()) {
                    this.myReadyLatch.countDown();
                }
            }
        }

        public void processTerminated(ProcessEvent event) {
            LOG.info("Process terminated with exit code " + event.getExitCode());
        }

        private boolean isReady() {
            return this.myStdOutBuffer.indexOf(READY_MESSAGE) >= 0;
        }

        public void awaitReady() throws ExecutionException {
            try {
                boolean ready = this.myReadyLatch.await(60L, TimeUnit.SECONDS);
                if (!ready) {
                    throw new ExecutionException("Cannot fetch core modules: timed out");
                }
                if (!this.isReady()) {
                    throw new AssertionError((Object)"Not ready for core modules configuration");
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }
}

