/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJsStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "runActivity"));
        }
        NodeJsStartupActivity.reconfigureCodeLibraryIfNeeded(project);
    }

    private static void reconfigureCodeLibraryIfNeeded(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "reconfigureCodeLibraryIfNeeded"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$reconfigureCodeLibraryIfNeeded$0"));
            }
            if (project.isDisposed()) {
                return;
            }
            List libraries = NodeJsCoreLibraryUtil.listOldLibraries((Project)project);
            if (!libraries.isEmpty()) {
                List<VirtualFile> roots = NodeJsStartupActivity.uniteScopes(project, libraries);
                NodeJsStartupActivity.doReconfigure(project, roots);
            } else {
                NodeJsStartupActivity.removeOldLibraryOrderEntries(project);
            }
        });
    }

    private static void removeOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "removeOldLibraryOrderEntries"));
        }
        if (NodeJsStartupActivity.hasOldLibraryOrderEntries(project)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$removeOldLibraryOrderEntries$2"));
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$null$1"));
                    }
                    NodeJsStartupActivity.doRemoveOldLibraryOrderEntries(project);
                });
            }, ModalityState.NON_MODAL, project.getDisposed());
        }
    }

    private static boolean hasOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "hasOldLibraryOrderEntries"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!NodeJsCoreLibraryUtil.isOldLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private static void doRemoveOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "doRemoveOldLibraryOrderEntries"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (!NodeJsCoreLibraryUtil.isOldLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                    model.removeOrderEntry(orderEntry);
                }
            });
        }
    }

    private static void doReconfigure(@NotNull Project project, @NotNull List<VirtualFile> rootsToAssociateWith) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "doReconfigure"));
        }
        if (rootsToAssociateWith == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "doReconfigure"));
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getDefault();
        if (interpreter instanceof NodeJsLocalInterpreter) {
            interpreter.provideCachedVersionOrFetch(version -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$doReconfigure$5"));
                }
                if (rootsToAssociateWith == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$doReconfigure$5"));
                }
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$null$4"));
                        }
                        if (rootsToAssociateWith == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToAssociateWith", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "lambda$null$4"));
                        }
                        NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
                        configurator.configureAndAssociateWith(interpreter, (SemVer)version, rootsToAssociateWith, null);
                    }, ModalityState.NON_MODAL, project.getDisposed());
                }
            });
        }
    }

    @NotNull
    private static List<VirtualFile> uniteScopes(@NotNull Project project, @NotNull List<ScriptingLibraryModel> libraries) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "uniteScopes"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "uniteScopes"));
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance((Project)project);
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (ScriptingLibraryModel library : libraries) {
            List files = mappings.getMappingsByLibraryName(library.getName());
            for (VirtualFile file : files) {
                if (file != null && !file.isValid()) continue;
                roots.add(file);
            }
        }
        for (VirtualFile root : roots) {
            if (root != null) continue;
            List<Object> list = Collections.singletonList(null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "uniteScopes"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile root : roots) {
            if (NodeJsStartupActivity.isInScope(roots, root)) continue;
            result.add(root);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "uniteScopes"));
        }
        return arrayList;
    }

    private static boolean isInScope(@NotNull Set<VirtualFile> roots, @NotNull VirtualFile f) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "isInScope"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/jetbrains/nodejs/library/NodeJsStartupActivity", "isInScope"));
        }
        for (VirtualFile root : roots) {
            if (f.equals(root) || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)f, (boolean)true)) continue;
            return true;
        }
        return false;
    }
}

