/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha;

import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaUtil {
    public static final String UI_BDD = "bdd";
    public static final String UI_TDD = "tdd";
    public static final String UI_EXPORTS = "exports";
    public static final String UI_QUNIT = "qunit";
    public static final String UI_REQUIRE = "require";
    public static final String MOCHA_COFFEE_COMPILER = "--compilers coffee:coffee-script/register";

    private MochaUtil() {
    }

    @NotNull
    public static List<String> getMochaUiList() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{UI_BDD, UI_TDD, UI_EXPORTS, UI_QUNIT, UI_REQUIRE});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/MochaUtil", "getMochaUiList"));
        }
        return arrayList;
    }

    @Nullable
    public static String findUi(@Nullable JSTestFileType testFileType) {
        if (testFileType == JSTestFileType.JASMINE) {
            return UI_BDD;
        }
        if (testFileType == JSTestFileType.QUNIT) {
            return UI_QUNIT;
        }
        if (testFileType == JSTestFileType.TDD) {
            return UI_TDD;
        }
        return null;
    }

    @NotNull
    public static String escapeJavaScriptPattern(@NotNull String testName) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/nodejs/mocha/MochaUtil", "escapeJavaScriptPattern"));
        }
        String regExpSpecialSymbols = ".?*+^=!:$[]\\(){}|-/";
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < testName.length(); ++i) {
            char ch = testName.charAt(i);
            if (StringUtil.containsChar((String)regExpSpecialSymbols, (char)ch)) {
                result.append("\\");
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/MochaUtil", "escapeJavaScriptPattern"));
        }
        return string;
    }
}

