/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKindView;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MochaDirectoryView
extends MochaTestKindView {
    private final TextFieldWithBrowseButton myTestDirTextFieldWithBrowseButton;
    private final JCheckBox myRecursiveCheckBox;
    private final JPanel myPanel;

    public MochaDirectoryView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "<init>"));
        }
        this.myTestDirTextFieldWithBrowseButton = MochaDirectoryView.createTestDirPathTextField(project);
        this.myRecursiveCheckBox = new JCheckBox("Include subdirectories");
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Test directory:", (JComponent)this.myTestDirTextFieldWithBrowseButton).addLabeledComponent("", (JComponent)this.myRecursiveCheckBox).getPanel();
    }

    @NotNull
    private static TextFieldWithBrowseButton createTestDirPathTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "createTestDirPathTextField"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)NodeJSBundle.message("runConfiguration.mocha.test_dir.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "createTestDirPathTextField"));
        }
        return textFieldWithBrowseButton2;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull MochaRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "resetFrom"));
        }
        this.myTestDirTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)settings.getTestDirPath()));
        this.myRecursiveCheckBox.setSelected(settings.isRecursive());
    }

    @Override
    public void applyTo(@NotNull MochaRunSettings.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/mocha/execution/MochaDirectoryView", "applyTo"));
        }
        builder.setTestDirPath(this.myTestDirTextFieldWithBrowseButton.getText());
        builder.setRecursive(this.myRecursiveCheckBox.isSelected());
    }
}

