/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaConfigurationType;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.util.NodeJsCoffeeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunConfigurationProducer
extends JsTestRunConfigurationProducer<MochaRunConfiguration> {
    public MochaRunConfigurationProducer() {
        super((ConfigurationType)MochaConfigurationType.getInstance(), (List)ImmutableList.of((Object)"mocha"));
    }

    private boolean isActiveFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "isActiveFor"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null) {
            return false;
        }
        if (this.isTestRunnerPackageAvailableFor(element.getProject(), file)) {
            return true;
        }
        List<VirtualFile> roots = MochaRunConfigurationProducer.collectMochaTestRoots(element.getProject());
        if (roots.isEmpty()) {
            return false;
        }
        HashSet dirs = ContainerUtil.newHashSet();
        for (VirtualFile root : roots) {
            if (root.isDirectory()) {
                dirs.add(root);
                continue;
            }
            if (!root.equals(file)) continue;
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)file, (Set)dirs);
    }

    @NotNull
    private static List<VirtualFile> collectMochaTestRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "collectMochaTestRoots"));
        }
        List list = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)MochaConfigurationType.getInstance());
        SmartList roots = new SmartList();
        for (RunConfiguration configuration : list) {
            VirtualFile dir;
            MochaRunConfiguration mrc = (MochaRunConfiguration)((Object)ObjectUtils.tryCast((Object)configuration, MochaRunConfiguration.class));
            if (mrc == null) continue;
            MochaRunSettings settings = mrc.getRunSettings();
            String path = null;
            if (settings.getTestKind() == MochaTestKind.DIRECTORY) {
                path = settings.getTestDirPath();
            } else if (settings.getTestKind() == MochaTestKind.TEST_FILE || settings.getTestKind() == MochaTestKind.SUITE || settings.getTestKind() == MochaTestKind.TEST) {
                path = settings.getTestFilePath();
            }
            if (StringUtil.isEmptyOrSpaces((String)path) || (dir = LocalFileSystem.getInstance().findFileByPath(path)) == null) continue;
            roots.add(dir);
        }
        SmartList smartList = roots;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "collectMochaTestRoots"));
        }
        return smartList;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        if (!this.isActiveFor(element)) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings runSettings = elementRunInfo.getRunSettings();
        if (runSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getExtraMochaOptions())) {
            String compilerMochaOption;
            PsiFile psiFile = element.getContainingFile();
            PsiFile psiFile2 = psiFile = psiFile != null ? psiFile.getOriginalFile() : null;
            if (psiFile != null && (compilerMochaOption = MochaRunConfigurationProducer.getLanguageCompilerMochaOption(psiFile)) != null) {
                runSettings = runSettings.builder().setExtraMochaOptions(compilerMochaOption).build();
            }
        }
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    @Nullable
    private static String getLanguageCompilerMochaOption(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "getLanguageCompilerMochaOption"));
        }
        if (NodeJsCoffeeUtil.isCoffee((PsiElement)psiFile)) {
            return "--compilers coffee:coffee-script/register";
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(psiFile.getFileType())) {
            return "--require ts-node/register";
        }
        return null;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    @Nullable
    private static Pair<String, JsTestElementPath> createSuiteOrTestData(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createSuiteOrTestData"));
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TextRange textRange = element.getTextRange();
        if (jsFile == null || textRange == null) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        JsTestElementPath path = jasmineStructure.findTestElementPath(textRange);
        if (path != null) {
            return Pair.create((Object)"bdd", (Object)path);
        }
        MochaTddFileStructure tddStructure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        path = tddStructure.findTestElementPath(textRange);
        if (path != null) {
            return Pair.create((Object)"tdd", (Object)path);
        }
        return null;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings thisRunSettings = elementRunInfo.getRunSettings();
        MochaRunSettings thatRunSettings = configuration.getRunSettings();
        if (thisRunSettings.getTestKind() != thatRunSettings.getTestKind()) {
            return false;
        }
        MochaTestKind testKind = thisRunSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return thisRunSettings.getTestDirPath().equals(thatRunSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return thisRunSettings.getTestFilePattern().equals(thatRunSettings.getTestFilePattern());
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath());
        }
        if (testKind == MochaTestKind.SUITE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getSuiteNames().equals(thatRunSettings.getSuiteNames());
        }
        if (testKind == MochaTestKind.TEST) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getTestNames().equals(thatRunSettings.getTestNames());
        }
        return false;
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull MochaRunSettings templateRunSettings) {
        JsTestElementPath testElementPath;
        String testName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createTestElementRunInfo"));
        }
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createTestElementRunInfo"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        Pair<String, JsTestElementPath> pair = MochaRunConfigurationProducer.createSuiteOrTestData(element);
        if (StringUtil.isEmptyOrSpaces((String)templateRunSettings.getWorkingDir())) {
            String workingDir = MochaRunConfigurationProducer.guessWorkingDir(element.getProject(), virtualFile);
            templateRunSettings = templateRunSettings.builder().setWorkingDir(workingDir).build();
        }
        if (pair == null) {
            return MochaRunConfigurationProducer.createFileInfo(element, virtualFile, templateRunSettings);
        }
        MochaRunSettings.Builder builder = templateRunSettings.builder();
        builder.setTestFilePath(virtualFile.getPath());
        if (templateRunSettings.getUi().isEmpty()) {
            builder.setUi((String)pair.getFirst());
        }
        if ((testName = (testElementPath = (JsTestElementPath)pair.getSecond()).getTestName()) == null) {
            builder.setTestKind(MochaTestKind.SUITE);
            builder.setSuiteNames(testElementPath.getSuiteNames());
        } else {
            builder.setTestKind(MochaTestKind.TEST);
            ArrayList names = ContainerUtil.newArrayList((Iterable)testElementPath.getSuiteNames());
            names.add(testName);
            builder.setTestNames(names);
        }
        return new TestElementInfo(builder.build(), testElementPath.getTestElement());
    }

    @NotNull
    private static String guessWorkingDir(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "guessWorkingDir"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "guessWorkingDir"));
        }
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file);
        if (root == null) {
            root = project.getBaseDir();
        }
        String string = FileUtil.toSystemDependentName((String)root.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "guessWorkingDir"));
        }
        return string;
    }

    @Nullable
    private static TestElementInfo createFileInfo(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull MochaRunSettings templateRunSettings) {
        JSTestFileType testFileType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createFileInfo"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createFileInfo"));
        }
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer", "createFileInfo"));
        }
        if (virtualFile.isDirectory()) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.DIRECTORY);
            builder.setTestDirPath(virtualFile.getPath());
            return new TestElementInfo(builder.build(), element);
        }
        JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        JSTestFileType jSTestFileType = testFileType = psiFile == null ? null : psiFile.getTestFileType();
        if (psiFile != null && testFileType != null) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.TEST_FILE);
            builder.setTestFilePath(virtualFile.getPath());
            if (templateRunSettings.getUi().isEmpty()) {
                String ui = MochaUtil.findUi(psiFile.getTestFileType());
                builder.setUi((String)ObjectUtils.notNull((Object)ui, (Object)"bdd"));
            }
            return new TestElementInfo(builder.build(), (PsiElement)psiFile);
        }
        return null;
    }

    private static class TestElementInfo {
        private final MochaRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        public TestElementInfo(@NotNull MochaRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo", "<init>"));
            }
            if (enclosingTestElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingTestElement", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo", "<init>"));
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public MochaRunSettings getRunSettings() {
            MochaRunSettings mochaRunSettings = this.myRunSettings;
            if (mochaRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo", "getRunSettings"));
            }
            return mochaRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo", "getEnclosingTestElement"));
            }
            return psiElement;
        }
    }
}

