/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaOutputToGeneralTestEventsConverter;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.mocha.execution.MochaTestLocationProvider;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final String FRAMEWORK_NAME = "MochaJavaScriptTestRunner";
    private final Project myProject;
    private final MochaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnv;
    private final String myMochaPackagePath;
    private final MochaRunSettings myRunSettings;

    public MochaRunProfileState(@NotNull Project project, @NotNull MochaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment env, @NotNull String mochaPackagePath, @NotNull MochaRunSettings runSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "<init>"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "<init>"));
        }
        if (mochaPackagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mochaPackagePath", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "<init>"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "<init>"));
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnv = env;
        this.myMochaPackagePath = mochaPackagePath;
        this.myRunSettings = runSettings;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        ConsoleView consoleView = this.createSMTRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "execute"));
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSMTRunnerConsoleView(@Nullable File workingDirectory) {
        MochaTestLocationProvider locator = new MochaTestLocationProvider(this.myRunSettings.getUi());
        MochaConsoleProperties testConsoleProperties = new MochaConsoleProperties(this.myRunConfiguration, this.myEnv.getExecutor(), locator);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "createSMTRunnerConsoleView"));
        }
        return baseTestsOutputConsoleView;
    }

    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        if (StringUtils.isNotBlank((String)this.myRunSettings.getWorkingDir())) {
            commandLine.withWorkDirectory(this.myRunSettings.getWorkingDir());
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, (List)nodeOptionList, (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        File mochaPackageDir = new File(this.myMochaPackagePath);
        commandLine.addParameter(MochaRunProfileState.getMochaMainJsFile(interpreter, mochaPackageDir).getAbsolutePath());
        String extraMochaOptions = this.myRunSettings.getExtraMochaOptions().trim();
        if (StringUtil.isNotEmpty((String)extraMochaOptions)) {
            commandLine.addParameters(ParametersList.parse((String)extraMochaOptions));
        }
        if (debugPort != -1) {
            commandLine.addParameter("--timeout");
            commandLine.addParameter("0");
        }
        commandLine.addParameter("--ui");
        commandLine.addParameter(this.myRunSettings.getUi());
        commandLine.addParameter("--reporter");
        commandLine.addParameter(MochaRunProfileState.getMochaReporterFile().getAbsolutePath());
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            if (this.myRunSettings.isRecursive()) {
                commandLine.addParameter("--recursive");
            }
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestDirPath()));
        } else if (MochaTestKind.PATTERN == testKind) {
            String pattern = this.myRunSettings.getTestFilePattern();
            if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
                commandLine.addParameters(ParametersList.parse((String)pattern));
            }
        } else if (MochaTestKind.TEST_FILE == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestFilePath()));
        } else if (MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestFilePath()));
            commandLine.addParameter("--grep");
            if (MochaTestKind.SUITE == testKind) {
                commandLine.addParameter(MochaUtil.escapeJavaScriptPattern(StringUtil.join(this.myRunSettings.getSuiteNames(), (String)" ") + " "));
            } else {
                commandLine.addParameter(MochaUtil.escapeJavaScriptPattern(StringUtil.join(this.myRunSettings.getTestNames(), (String)" ")) + "$");
            }
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        return commandLine;
    }

    @NotNull
    private static File getMochaMainJsFile(@NotNull NodeJsLocalInterpreter interpreter, @NotNull File mochaPackageDir) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "getMochaMainJsFile"));
        }
        if (mochaPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mochaPackageDir", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "getMochaMainJsFile"));
        }
        String packageName = mochaPackageDir.getName();
        File mainJsFile = "electron-mocha".equals(packageName) ? (interpreter.isElectron() ? new File(mochaPackageDir, "index.js") : new File(mochaPackageDir, "bin" + File.separator + "electron-mocha")) : new File(mochaPackageDir, "bin" + File.separator + "_mocha");
        if (!mainJsFile.isFile()) {
            throw new ExecutionException("Not found " + mainJsFile.getAbsolutePath());
        }
        File file = mainJsFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "getMochaMainJsFile"));
        }
        return file;
    }

    @NotNull
    private static File getMochaReporterFile() throws ExecutionException {
        File file;
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir("mocha-intellij/lib/mochaIntellijReporter.js");
        }
        catch (IOException e) {
            throw new ExecutionException("IntelliJ Mocha reporter not found", (Throwable)e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState", "getMochaReporterFile"));
        }
        return file;
    }

    private static class MochaConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        public MochaConsoleProperties(MochaRunConfiguration configuration, Executor executor, SMTestLocator locator) {
            super((RunConfiguration)configuration, MochaRunProfileState.FRAMEWORK_NAME, executor);
            this.myLocator = locator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState$MochaConsoleProperties", "createTestEventsConverter"));
            }
            if (consoleProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState$MochaConsoleProperties", "createTestEventsConverter"));
            }
            return new MochaOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }
    }
}

