/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RerunTestsAction;
import com.intellij.execution.runners.RerunTestsNotification;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class MochaRunProgramRunner
extends GenericProgramRunner {
    @NotNull
    public String getRunnerId() {
        if ("RunnerForMochaJavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunProgramRunner", "getRunnerId"));
        }
        return "RunnerForMochaJavaScript";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/nodejs/mocha/execution/MochaRunProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/nodejs/mocha/execution/MochaRunProgramRunner", "canRun"));
        }
        return DefaultRunExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof MochaRunConfiguration;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/nodejs/mocha/execution/MochaRunProgramRunner", "doExecute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/mocha/execution/MochaRunProgramRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        RunContentDescriptor descriptor = new RunContentBuilder(executionResult, environment).showRunContent(environment.getContentToReuse());
        RerunTestsNotification.showRerunNotification((RunContentDescriptor)environment.getContentToReuse(), (ExecutionConsole)executionResult.getExecutionConsole());
        RerunTestsAction.register((RunContentDescriptor)descriptor);
        return descriptor;
    }
}

