/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.javascript.testFramework.util.TestFullNameView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKindView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MochaTestView
extends MochaTestKindView {
    private final TextFieldWithBrowseButton myTestFileTextFieldWithBrowseButton;
    private final TestFullNameView myTestFullNameView;
    private final JPanel myPanel;

    public MochaTestView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestView", "<init>"));
        }
        this.myTestFileTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)this.myTestFileTextFieldWithBrowseButton, (String)NodeJSBundle.message("runConfiguration.mocha.test_file.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myTestFullNameView = new TestFullNameView();
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Test file:", (JComponent)this.myTestFileTextFieldWithBrowseButton).addLabeledComponent("Test name:", this.myTestFullNameView.getComponent()).getPanel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaTestView", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull MochaRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/mocha/execution/MochaTestView", "resetFrom"));
        }
        this.myTestFileTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)settings.getTestFilePath()));
        this.myTestFullNameView.setNames(settings.getTestNames());
    }

    @Override
    public void applyTo(@NotNull MochaRunSettings.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/mocha/execution/MochaTestView", "applyTo"));
        }
        builder.setTestFilePath(this.myTestFileTextFieldWithBrowseButton.getText());
        builder.setTestNames(this.myTestFullNameView.getNames());
    }
}

