/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunConfiguration;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeunitExecutionUtils {
    private NodeunitExecutionUtils() {
    }

    public static ConsoleView createConsole(@NotNull ProcessHandler processHandler, @NotNull ExecutionEnvironment env, @NotNull SMTestLocator locator) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "createConsole"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "createConsole"));
        }
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "createConsole"));
        }
        NodeunitRunConfiguration runConfiguration = (NodeunitRunConfiguration)env.getRunProfile();
        NodeunitConsoleProperties testConsoleProperties = new NodeunitConsoleProperties(runConfiguration, env.getExecutor(), locator);
        BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)"Nodeunit", (TestConsoleProperties)testConsoleProperties);
        testsOutputConsoleView.attachToProcess(processHandler);
        Disposer.register((Disposable)env.getProject(), (Disposable)testsOutputConsoleView);
        return testsOutputConsoleView;
    }

    public static void checkConfiguration(@NotNull Project project, @NotNull NodeunitSettings settings) throws RuntimeConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "checkConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "checkConfiguration"));
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        String nodeunitModuleDirPath = settings.getNodeunitPackageDir();
        if (nodeunitModuleDirPath.isEmpty() || ".".equals(nodeunitModuleDirPath)) {
            throw new RuntimeConfigurationError("Please specify nodeunit module directory correctly.");
        }
        File nodeunitModuleDir = new File(nodeunitModuleDirPath);
        if (!nodeunitModuleDir.isDirectory()) {
            throw new RuntimeConfigurationError("Please specify nodeunit module directory correctly.");
        }
        String workingDirectoryStr = settings.getWorkingDirectory();
        if (workingDirectoryStr.isEmpty() || ".".equals(workingDirectoryStr)) {
            throw new RuntimeConfigurationError("Please specify working directory correctly.");
        }
        File workingDirectory = new File(workingDirectoryStr);
        if (!workingDirectory.isDirectory()) {
            throw new RuntimeConfigurationError("Please specify working directory correctly.");
        }
        if (settings.getTestType() == NodeunitTestType.DIRECTORY) {
            if (settings.getDirectory().isEmpty()) {
                throw new RuntimeConfigurationError("Please specify nonempty test directory.");
            }
            File testDirectory = new File(workingDirectory, settings.getDirectory());
            if (!testDirectory.isDirectory()) {
                throw new RuntimeConfigurationError("Please specify test directory correctly.");
            }
        } else {
            File jsTestFile = new File(workingDirectory, settings.getJsFile());
            if (!jsTestFile.isFile()) {
                throw new RuntimeConfigurationError("Please specify JavaScript test file correctly.");
            }
        }
    }

    @NotNull
    public static List<String> detectAllNodeunitPackages(@NotNull Project project, @NotNull NodeJsInterpreterRef interpreterRef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "detectAllNodeunitPackages"));
        }
        if (interpreterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "detectAllNodeunitPackages"));
        }
        ArrayList paths = ContainerUtil.newArrayList();
        NodeJsInterpreter interpreter = interpreterRef.resolve(project);
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        NodeSettings nodeSettings = null;
        if (localInterpreter != null) {
            nodeSettings = new NodeSettings(localInterpreter.getInterpreterSystemDependentPath());
        }
        VirtualFile requester = project.getBaseDir();
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"nodeunit", (VirtualFile)requester, (NodeSettings)nodeSettings, (boolean)true);
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            paths.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils", "detectAllNodeunitPackages"));
        }
        return arrayList;
    }

    private static class NodeunitConsoleProperties
    extends SMTRunnerConsoleProperties {
        private final SMTestLocator myLocator;

        public NodeunitConsoleProperties(NodeunitRunConfiguration configuration, Executor executor, SMTestLocator locator) {
            super((RunConfiguration)configuration, "Nodeunit", executor);
            this.myLocator = locator;
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }
    }
}

