/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunProfileState;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettingsSerializationUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.nodeunit.execution.ui.NodeunitSettingsEditor;
import java.net.InetSocketAddress;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeunitRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration {
    private NodeunitSettings mySettings;

    public NodeunitRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.mySettings = new NodeunitSettings.Builder().build();
    }

    public void initializeFields() {
        List<String> all;
        String path;
        VirtualFile dir;
        if (this.mySettings.getWorkingDirectory().isEmpty() && (dir = this.getProject().getBaseDir()) != null) {
            this.mySettings = this.mySettings.builder().setWorkingDirectory(dir.getPath()).build();
        }
        if (this.mySettings.getTestType() == NodeunitTestType.DIRECTORY && this.mySettings.getDirectory().isEmpty()) {
            String workingDirPath = this.mySettings.getWorkingDirectory();
            VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(workingDirPath);
            if (workingDir != null && workingDir.isValid() && workingDir.isDirectory()) {
                String testDirName;
                String[] testDirNames = new String[]{"test", "spec", "tests", "specs"};
                VirtualFile testDir = null;
                String[] stringArray = testDirNames;
                int n = stringArray.length;
                for (int i = 0; !(i >= n || (testDir = workingDir.findChild(testDirName = stringArray[i])) != null && testDir.isValid() && testDir.isDirectory()); ++i) {
                }
                if (testDir != null) {
                    this.mySettings = this.mySettings.builder().setDirectory(testDir.getPath()).build();
                }
            }
        }
        if (this.mySettings.getNodeunitPackageDir().isEmpty() && (path = (String)ContainerUtil.getFirstItem(all = NodeunitExecutionUtils.detectAllNodeunitPackages(this.getProject(), this.mySettings.getInterpreterRef()))) != null) {
            this.mySettings = this.mySettings.builder().setNodeunitPackageDir(path).build();
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        NodeunitSettingsEditor nodeunitSettingsEditor = new NodeunitSettingsEditor(this.getProject());
        if (nodeunitSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "getConfigurationEditor"));
        }
        return nodeunitSettingsEditor;
    }

    @NotNull
    public NodeunitSettings getSettings() {
        NodeunitSettings nodeunitSettings = this.mySettings;
        if (nodeunitSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "getSettings"));
        }
        return nodeunitSettings;
    }

    public void setSettings(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "setSettings"));
        }
        this.mySettings = settings;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        NodeunitSettings settings = NodeunitSettingsSerializationUtils.readFromJDomElement(element);
        this.setSettings(settings);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        NodeunitSettingsSerializationUtils.writeToJDomElement(element, this.mySettings);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "getState"));
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
        return new NodeunitRunProfileState(environment, this.mySettings);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeunitExecutionUtils.checkConfiguration(this.getProject(), this.mySettings);
    }

    @NotNull
    public String suggestedName() {
        NodeunitSettings settings = this.getSettings();
        if (settings.getTestType() == NodeunitTestType.DIRECTORY) {
            if (!settings.getDirectory().isEmpty()) {
                String string = "All in " + settings.getDirectory();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "suggestedName"));
                }
                return string;
            }
        } else if (!settings.getJsFile().isEmpty()) {
            String string = settings.getJsFile();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "suggestedName"));
            }
            return string;
        }
        if ("Unnamed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration", "suggestedName"));
        }
        return "Unnamed";
    }

    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }
}

