/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NodeunitSettingsSerializationUtils {
    private NodeunitSettingsSerializationUtils() {
    }

    @NotNull
    public static NodeunitSettings readFromJDomElement(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readFromJDomElement"));
        }
        NodeunitSettings.Builder builder = new NodeunitSettings.Builder();
        String interpreterRefName = JDOMExternalizer.readString((Element)element, (String)Key.NODE_PATH.getKey());
        if (interpreterRefName != null) {
            builder.setInterpreterRef(NodeJsInterpreterRef.create((String)interpreterRefName));
        }
        EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)element);
        builder.setEnvData(envData);
        String workingDirectoryPath = NodeunitSettingsSerializationUtils.readString(element, Key.WORKING_DIRECTORY, "");
        if (!workingDirectoryPath.isEmpty()) {
            builder.setWorkingDirectory(FileUtil.toSystemDependentName((String)workingDirectoryPath));
        }
        String nodeunitModuleDirPath = NodeunitSettingsSerializationUtils.readString(element, Key.NODEUNIT_MODULE_DIR, "");
        builder.setNodeunitPackageDir(FileUtil.toSystemDependentName((String)nodeunitModuleDirPath));
        NodeunitTestType testType = NodeunitSettingsSerializationUtils.readEnumByName(element, Key.TEST_TYPE, NodeunitTestType.JS_FILE);
        builder.setTestType(testType);
        if (testType == NodeunitTestType.DIRECTORY) {
            NodeunitSettingsSerializationUtils.readDirectory(builder, element);
        } else if (testType == NodeunitTestType.JS_FILE) {
            NodeunitSettingsSerializationUtils.readJsFile(builder, element);
        } else if (testType == NodeunitTestType.TEST) {
            NodeunitSettingsSerializationUtils.readTest(builder, element);
        } else {
            throw new RuntimeException("Unknown testType: " + (Object)((Object)testType));
        }
        NodeunitSettings nodeunitSettings = builder.build();
        if (nodeunitSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readFromJDomElement"));
        }
        return nodeunitSettings;
    }

    private static void readDirectory(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readDirectory"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readDirectory"));
        }
        String directory = NodeunitSettingsSerializationUtils.readString(element, Key.DIRECTORY, "");
        builder.setDirectory(FileUtil.toSystemDependentName((String)directory));
    }

    private static void readJsFile(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readJsFile"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readJsFile"));
        }
        String jsFile = NodeunitSettingsSerializationUtils.readString(element, Key.JS_FILE, "");
        builder.setJsFilePath(FileUtil.toSystemDependentName((String)jsFile));
    }

    private static void readTest(@NotNull NodeunitSettings.Builder builder, @NotNull Element element) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readTest"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readTest"));
        }
        NodeunitSettingsSerializationUtils.readJsFile(builder, element);
        String testName = NodeunitSettingsSerializationUtils.readString(element, Key.TEST_NAME, "");
        builder.setTest(testName);
    }

    public static void writeToJDomElement(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeToJDomElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeToJDomElement"));
        }
        JDOMExternalizer.write((Element)element, (String)Key.NODE_PATH.getKey(), (String)settings.getInterpreterRef().getReferenceName());
        settings.getEnvData().writeExternal(element);
        NodeunitSettingsSerializationUtils.writeString(element, Key.NODEUNIT_MODULE_DIR, FileUtil.toSystemIndependentName((String)settings.getNodeunitPackageDir()));
        NodeunitSettingsSerializationUtils.writeString(element, Key.WORKING_DIRECTORY, FileUtil.toSystemIndependentName((String)settings.getWorkingDirectory()));
        NodeunitTestType testType = settings.getTestType();
        NodeunitSettingsSerializationUtils.writeString(element, Key.TEST_TYPE, testType.name());
        if (testType == NodeunitTestType.DIRECTORY) {
            NodeunitSettingsSerializationUtils.writeDirectory(element, settings);
        } else if (testType == NodeunitTestType.JS_FILE) {
            NodeunitSettingsSerializationUtils.writeJsFile(element, settings);
        } else if (testType == NodeunitTestType.TEST) {
            NodeunitSettingsSerializationUtils.writeTest(element, settings);
        } else {
            throw new RuntimeException("Unknown testType: " + (Object)((Object)testType));
        }
    }

    private static void writeTest(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeTest"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeTest"));
        }
        NodeunitSettingsSerializationUtils.writeJsFile(element, settings);
        String testName = settings.getTestName();
        NodeunitSettingsSerializationUtils.writeString(element, Key.TEST_NAME, testName);
    }

    private static void writeDirectory(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeDirectory"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeDirectory"));
        }
        String directory = FileUtil.toSystemIndependentName((String)settings.getDirectory());
        NodeunitSettingsSerializationUtils.writeString(element, Key.DIRECTORY, directory);
    }

    private static void writeJsFile(@NotNull Element element, @NotNull NodeunitSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeJsFile"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "writeJsFile"));
        }
        String jsFilePath = settings.getJsFile();
        NodeunitSettingsSerializationUtils.writeString(element, Key.JS_FILE, FileUtil.toSystemIndependentName((String)jsFilePath));
    }

    @NotNull
    private static <E extends Enum<E>> E readEnumByName(@NotNull Element element, @NotNull Key key, @NotNull E defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readEnumByName"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readEnumByName"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readEnumByName"));
        }
        String str = NodeunitSettingsSerializationUtils.readString(element, key, "");
        E enumConstant = NodeunitSettingsSerializationUtils.findEnumByName(defaultValue.getDeclaringClass(), str);
        Enum enum_ = (Enum)ObjectUtils.notNull(enumConstant, defaultValue);
        if (enum_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readEnumByName"));
        }
        return (E)enum_;
    }

    private static <E extends Enum> E findEnumByName(@NotNull Class<E> enumClass, @NotNull String value) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "findEnumByName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "findEnumByName"));
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!value.equals(e.name())) continue;
            return (E)e;
        }
        return null;
    }

    private static void writeString(Element element, Key key, String value) {
        JDOMExternalizer.write((Element)element, (String)key.getKey(), (String)value);
    }

    @NotNull
    private static String readString(@NotNull Element element, @NotNull Key key, @NotNull String defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readString"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readString"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readString"));
        }
        String value = JDOMExternalizer.readString((Element)element, (String)key.getKey());
        String string = StringUtil.notNullize((String)value, (String)defaultValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettingsSerializationUtils", "readString"));
        }
        return string;
    }

    private static enum Key {
        NODE_PATH("nodePath"),
        PASS_PARENT_ENV_VARS("passParentEnvVars"),
        NODEUNIT_MODULE_DIR("nodeunitModuleDir"),
        WORKING_DIRECTORY("workingDirectory"),
        TEST_TYPE("testType"),
        DIRECTORY("directory"),
        JS_FILE("jsFile"),
        TEST_NAME("testName");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

