/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsControllerFactory;
import com.jetbrains.nodejs.util.RelativePathUIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsTestFileSettingsController
implements SettingsController {
    public static final SettingsControllerFactory FACTORY = new SettingsControllerFactory(){

        @Override
        @NotNull
        public SettingsController createSettingsController(@NotNull Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController$1", "createSettingsController"));
            }
            JsTestFileSettingsController jsTestFileSettingsController = new JsTestFileSettingsController(context);
            if (jsTestFileSettingsController == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController$1", "createSettingsController"));
            }
            return jsTestFileSettingsController;
        }
    };
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final TextFieldWithBrowseButton myJsTestFilePathTextFieldWithBrowseButton;

    public JsTestFileSettingsController(final @NotNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController", "<init>"));
        }
        this.myPanel = new JPanel(new GridBagLayout());
        JBLabel jsTestFileLabel = new JBLabel("Test file:");
        jsTestFileLabel.setAnchor(context.getAnchor());
        this.myPanel.add((Component)jsTestFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 10), 0, 0));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        descriptor.setTitle("Select a JavaScript file with tests");
        JTextField workingDirectory = (JTextField)ObjectUtils.assertNotNull((Object)context.getWorkingDirectory());
        this.myJsTestFilePathTextFieldWithBrowseButton = RelativePathUIUtil.createRelativePathTextFieldAndTrackBaseDirChanges(context.getProject(), descriptor, workingDirectory.getDocument());
        this.myJsTestFilePathTextFieldWithBrowseButton.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, context.getProject()){

            @Nullable
            protected VirtualFile getInitialFile() {
                JTextField workingDirectory = (JTextField)ObjectUtils.assertNotNull((Object)context.getWorkingDirectory());
                String workingDirectoryStr = StringUtil.notNullize((String)workingDirectory.getText());
                if (workingDirectoryStr.isEmpty()) {
                    return null;
                }
                File wd = new File(workingDirectoryStr);
                String text = this.getComponentText();
                File resultFile = new File(text);
                if (!resultFile.isAbsolute()) {
                    resultFile = new File(wd, text);
                }
                if (resultFile.exists()) {
                    return VfsUtil.findFileByIoFile((File)resultFile, (boolean)false);
                }
                return super.getInitialFile();
            }
        });
        this.myPanel.add((Component)this.myJsTestFilePathTextFieldWithBrowseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController", "resetFrom"));
        }
        this.myJsTestFilePathTextFieldWithBrowseButton.setText(settings.getJsFile());
    }

    @Override
    public void applyTo(@NotNull NodeunitSettings.Builder settingsBuilder) {
        if (settingsBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsBuilder", "com/jetbrains/nodejs/nodeunit/execution/ui/JsTestFileSettingsController", "applyTo"));
        }
        settingsBuilder.setJsFilePath(this.myJsTestFilePathTextFieldWithBrowseButton.getText());
    }
}

