/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.IdProvider;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsControllerFactory;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class OneOfSettingsController<T extends IdProvider & SettingsControllerFactory>
implements SettingsController {
    @NotNull
    private final JPanel myCardPanel;
    private final Map<String, SettingsController> mySectionByIdMap;
    private T mySelectedKey;

    public OneOfSettingsController(@NotNull Context context, @NotNull Collection<T> childFactories) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "<init>"));
        }
        if (childFactories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFactories", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "<init>"));
        }
        this.mySectionByIdMap = ContainerUtil.newHashMap();
        this.myCardPanel = new JPanel(new CardLayout());
        for (IdProvider childFactory : childFactories) {
            SettingsController settingsController = ((SettingsControllerFactory)((Object)childFactory)).createSettingsController(context);
            JComponent childComponent = settingsController.getComponent();
            this.myCardPanel.add((Component)childComponent, childFactory.getId());
            this.mySectionByIdMap.put(childFactory.getId(), settingsController);
        }
        Iterator<T> iterator = childFactories.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("No child items were found");
        }
        this.select((IdProvider)iterator.next());
    }

    @Override
    public void resetFrom(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "resetFrom"));
        }
        SettingsController settingsController = this.getSelectedSettingsController();
        settingsController.resetFrom(settings);
    }

    @Override
    public void applyTo(@NotNull NodeunitSettings.Builder settingsBuilder) {
        if (settingsBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsBuilder", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "applyTo"));
        }
        SettingsController settingsController = this.getSelectedSettingsController();
        settingsController.applyTo(settingsBuilder);
    }

    @Override
    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myCardPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "getComponent"));
        }
        return jPanel;
    }

    public void select(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/nodeunit/execution/ui/OneOfSettingsController", "select"));
        }
        if (this.mySelectedKey != key) {
            CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
            cardLayout.show(this.myCardPanel, key.getId());
            this.mySelectedKey = key;
        }
    }

    public T getSelectedKey() {
        return this.mySelectedKey;
    }

    private SettingsController getSelectedSettingsController() {
        return this.mySectionByIdMap.get(this.mySelectedKey.getId());
    }
}

