/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.DirectorySettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.IdProvider;
import com.jetbrains.nodejs.nodeunit.execution.ui.JsTestFileSettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.OneOfSettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsControllerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class RootSettingsController
implements SettingsController {
    private final JPanel myPanel;
    private final ComboBox myTestTypeOptionComboBox;
    private final ImmutableMap<NodeunitTestType, TestTypeOption> myOptionByTestTypeMap;
    private final OneOfSettingsController<TestTypeOption> myTestTypeContentSettingsController;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVariablesField;
    private final TextFieldWithBrowseButton myWorkingDirectoryTextFieldWithBrowseButton;
    private final TextFieldWithHistoryWithBrowseButton myNodeunitPackageDirField;

    RootSettingsController(@NotNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "<init>"));
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(context.getProject(), false);
        this.myWorkingDirectoryTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.myWorkingDirectoryTextFieldWithBrowseButton.addBrowseFolderListener("Select Working Directory", null, context.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myEnvVariablesField = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myNodeunitPackageDirField = RootSettingsController.createNodeunitPackageField(context.getProject(), this.myNodeInterpreterField);
        List<TestTypeOption> testTypeOptions = RootSettingsController.createTestTypeOptions();
        this.myOptionByTestTypeMap = RootSettingsController.createOptionByTestTypeMap(testTypeOptions);
        this.myTestTypeOptionComboBox = this.createTestTypeOptionComboBox(testTypeOptions);
        JLabel envVarLabel = new JLabel("Environment variables:");
        this.myTestTypeContentSettingsController = new OneOfSettingsController<TestTypeOption>(new Context(context.getProject(), envVarLabel, this.myWorkingDirectoryTextFieldWithBrowseButton.getTextField()), testTypeOptions);
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent("Node interpreter:", (JComponent)this.myNodeInterpreterField);
        builder.addLabeledComponent("Working directory:", (JComponent)this.myWorkingDirectoryTextFieldWithBrowseButton);
        builder.addLabeledComponent((JComponent)envVarLabel, (JComponent)this.myEnvVariablesField);
        builder.addLabeledComponent("Nodeunit module:", (JComponent)this.myNodeunitPackageDirField);
        builder.addLabeledComponent("Run:", (JComponent)this.myTestTypeOptionComboBox);
        builder.addComponent((JComponent)this.myTestTypeContentSettingsController.getComponent());
        this.myPanel = builder.getPanel();
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createNodeunitPackageField(@NotNull Project project, @NotNull NodeJsInterpreterField interpreterField) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createNodeunitPackageField"));
        }
        if (interpreterField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterField", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createNodeunitPackageField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select nodeunit Module Directory", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "lambda$createNodeunitPackageField$0"));
            }
            if (interpreterField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterField", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "lambda$createNodeunitPackageField$0"));
            }
            List<String> dirs = NodeunitExecutionUtils.detectAllNodeunitPackages(project, interpreterField.getInterpreterRef());
            Collections.sort(dirs);
            return dirs;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createNodeunitPackageField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "resetFrom"));
        }
        this.myNodeInterpreterField.setInterpreterRef(settings.getInterpreterRef());
        this.myEnvVariablesField.setData(settings.getEnvData());
        this.myNodeunitPackageDirField.setText(FileUtil.toSystemDependentName((String)settings.getNodeunitPackageDir()));
        this.myWorkingDirectoryTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)settings.getWorkingDirectory()));
        this.selectTestType(settings.getTestType());
        this.myTestTypeContentSettingsController.resetFrom(settings);
    }

    @Override
    public void applyTo(@NotNull NodeunitSettings.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "applyTo"));
        }
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEnvData(this.myEnvVariablesField.getData());
        builder.setNodeunitPackageDir(this.myNodeunitPackageDirField.getText());
        builder.setWorkingDirectory(this.myWorkingDirectoryTextFieldWithBrowseButton.getText());
        builder.setTestType(this.getSelectedTestType());
        this.myTestTypeContentSettingsController.applyTo(builder);
    }

    @NotNull
    private static List<TestTypeOption> createTestTypeOptions() {
        List<TestTypeOption> list = Arrays.asList(new TestTypeOption(NodeunitTestType.DIRECTORY, "All test files in directory", DirectorySettingsController.FACTORY), new TestTypeOption(NodeunitTestType.JS_FILE, "Test file", JsTestFileSettingsController.FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createTestTypeOptions"));
        }
        return list;
    }

    @NotNull
    public static ImmutableMap<NodeunitTestType, TestTypeOption> createOptionByTestTypeMap(@NotNull List<TestTypeOption> testTypeOptions) {
        if (testTypeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testTypeOptions", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createOptionByTestTypeMap"));
        }
        ImmutableMap immutableMap = Maps.uniqueIndex(testTypeOptions, (Function)new Function<TestTypeOption, NodeunitTestType>(){

            public NodeunitTestType apply(TestTypeOption input) {
                return input.getTestType();
            }
        });
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createOptionByTestTypeMap"));
        }
        return immutableMap;
    }

    @NotNull
    private ComboBox createTestTypeOptionComboBox(@NotNull List<TestTypeOption> testTypeOptions) {
        if (testTypeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testTypeOptions", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createTestTypeOptionComboBox"));
        }
        ComboBox comboBox = new ComboBox(testTypeOptions.toArray());
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<TestTypeOption>(){

            public void customize(JList list, TestTypeOption value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootSettingsController.this.selectTestType(RootSettingsController.this.getSelectedTestType());
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "createTestTypeOptionComboBox"));
        }
        return comboBox2;
    }

    private void selectTestType(@NotNull NodeunitTestType testType) {
        if (testType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testType", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "selectTestType"));
        }
        TestTypeOption testTypeOption = (TestTypeOption)this.myOptionByTestTypeMap.get((Object)testType);
        if (testTypeOption == null) {
            throw new RuntimeException("Can't find TestTypeOption by " + (Object)((Object)testType) + ", index is " + this.myOptionByTestTypeMap);
        }
        ComboBoxModel comboBoxModel = this.myTestTypeOptionComboBox.getModel();
        if (comboBoxModel.getSelectedItem() != testTypeOption) {
            comboBoxModel.setSelectedItem(testTypeOption);
        }
        this.myTestTypeContentSettingsController.select(testTypeOption);
    }

    @NotNull
    private NodeunitTestType getSelectedTestType() {
        NodeunitTestType nodeunitTestType = ((TestTypeOption)this.myTestTypeOptionComboBox.getSelectedItem()).getTestType();
        if (nodeunitTestType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController", "getSelectedTestType"));
        }
        return nodeunitTestType;
    }

    static class TestTypeOption
    implements IdProvider,
    SettingsControllerFactory {
        private final NodeunitTestType myTestType;
        private final String myDisplayName;
        private final SettingsControllerFactory mySettingsControllerFactory;

        public TestTypeOption(@NotNull NodeunitTestType testType, @NotNull String displayName, @NotNull SettingsControllerFactory settingsControllerFactory) {
            if (testType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testType", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "<init>"));
            }
            if (displayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "<init>"));
            }
            if (settingsControllerFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsControllerFactory", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "<init>"));
            }
            this.myTestType = testType;
            this.myDisplayName = displayName;
            this.mySettingsControllerFactory = settingsControllerFactory;
        }

        @NotNull
        public NodeunitTestType getTestType() {
            NodeunitTestType nodeunitTestType = this.myTestType;
            if (nodeunitTestType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "getTestType"));
            }
            return nodeunitTestType;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myTestType.name();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "getId"));
            }
            return string;
        }

        @Override
        @NotNull
        public SettingsController createSettingsController(@NotNull Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "createSettingsController"));
            }
            SettingsController settingsController = this.mySettingsControllerFactory.createSettingsController(context);
            if (settingsController == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "createSettingsController"));
            }
            return settingsController;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/RootSettingsController$TestTypeOption", "getDisplayName"));
            }
            return string;
        }
    }
}

